/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop;

import java.util.Properties;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.sqoop.SqoopOptions;

public class SqoopJobDataPublisher {
    public void publish(Data data) throws Exception {
    }

    public static class Data {
        public static final String JDBC_STORE = "JDBCStore";
        String operation;
        String user;
        String storeType;
        String storeTable;
        String storeQuery;
        String hiveDB;
        String hiveTable;
        Properties commandLineOpts;
        long startTime;
        long endTime;
        String url;

        public String getOperation() {
            return this.operation;
        }

        public String getUser() {
            return this.user;
        }

        public String getStoreType() {
            return this.storeType;
        }

        public String getStoreTable() {
            return this.storeTable;
        }

        public String getStoreQuery() {
            return this.storeQuery;
        }

        public String getHiveDB() {
            return this.hiveDB;
        }

        public String getHiveTable() {
            return this.hiveTable;
        }

        public Properties getOptions() {
            return this.commandLineOpts;
        }

        public String getUrl() {
            return this.url;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        private void init(String operation, String url, String user, String storeType, String storeTable, String storeQuery, String hiveDB, String hiveTable, Properties commandLineOpts, long startTime, long endTime) {
            this.operation = operation;
            this.url = url;
            this.user = user;
            this.storeType = storeType;
            this.storeTable = storeTable == null ? hiveTable : storeTable;
            this.storeQuery = storeQuery;
            this.hiveDB = hiveDB == null ? "default" : hiveDB;
            this.hiveTable = hiveTable;
            this.commandLineOpts = commandLineOpts;
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public Data(String operation, String url, String user, String storeType, String storeTable, String storeQuery, String hiveDB, String hiveTable, Properties commandLineOpts, long startTime, long endTime) throws Exception {
            this.init(operation, url, user, storeType, storeTable, storeQuery, hiveDB, hiveTable, commandLineOpts, startTime, endTime);
        }

        public Data(String operation, SqoopOptions options, String tableName, long startTime, long endTime) throws Exception {
            String hiveTableName = null;
            String hiveDatabase = null;
            if ("export".equals(operation)) {
                hiveTableName = options.getHCatTableName();
                hiveDatabase = options.getHCatDatabaseName();
            } else if ("import".equals(operation)) {
                hiveTableName = options.doHiveImport() ? options.getHiveTableName() : options.getHCatTableName();
                hiveDatabase = options.doHiveImport() ? options.getHiveDatabaseName() : options.getHCatDatabaseName();
            } else {
                throw new Exception("Data published for unsupported Operation " + operation + " in SqoopJobDataPublisher");
            }
            String dataStoreType = JDBC_STORE;
            String[] storeTypeFields = options.getConnectString().split(":");
            if (storeTypeFields.length > 2) {
                dataStoreType = storeTypeFields[1];
            }
            this.init(operation, options.getConnectString(), UserGroupInformation.getCurrentUser().getShortUserName(), dataStoreType, tableName, options.getSqlQuery(), hiveDatabase, hiveTableName, options.writeProperties(), startTime, endTime);
        }

        public String toString() {
            return "Operation=" + this.operation + ", Url=" + this.url + ", User=" + this.user + ", StoreType=" + this.storeType + ", StoreTable=" + this.storeTable + ", StoreQuery=" + this.storeQuery + ", HiveDB=" + this.hiveDB + ", HiveTable=" + this.hiveTable + ", StartTime=" + this.startTime + ", EndTime=" + this.endTime + ", CmdLineArgs=" + this.commandLineOpts;
        }
    }
}

