/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.io.SplittableBufferedWriter;
import com.cloudera.sqoop.manager.ExportJobContext;
import com.cloudera.sqoop.manager.ImportJobContext;
import com.cloudera.sqoop.manager.PostgresqlManager;
import com.cloudera.sqoop.util.DirectImportUtils;
import com.cloudera.sqoop.util.ErrorableAsyncSink;
import com.cloudera.sqoop.util.ErrorableThread;
import com.cloudera.sqoop.util.Executor;
import com.cloudera.sqoop.util.ExportException;
import com.cloudera.sqoop.util.ImportException;
import com.cloudera.sqoop.util.JdbcUrl;
import com.cloudera.sqoop.util.LoggingAsyncSink;
import com.cloudera.sqoop.util.PerfCounters;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.sqoop.cli.RelatedOptions;
import org.apache.sqoop.mapreduce.ExportInputFormat;
import org.apache.sqoop.mapreduce.postgresql.PostgreSQLCopyExportJob;
import org.apache.sqoop.util.AsyncSink;
import org.apache.sqoop.util.PostgreSQLUtils;
import org.apache.sqoop.util.SubstitutionUtils;

public class DirectPostgresqlManager
extends PostgresqlManager {
    public static final Log LOG = LogFactory.getLog((String)DirectPostgresqlManager.class.getName());
    public static final String BOOLEAN_TRUE_STRING = "boolean-true-string";
    public static final String DEFAULT_BOOLEAN_TRUE_STRING = "TRUE";
    public static final String BOOLEAN_FALSE_STRING = "boolean-false-string";
    public static final String DEFAULT_BOOLEAN_FALSE_STRING = "FALSE";
    private static final String PSQL_CMD = "psql";
    private String booleanTrueString;
    private String booleanFalseString;

    public DirectPostgresqlManager(SqoopOptions opts) {
        super(opts);
        if (this.booleanFalseString == null) {
            this.booleanFalseString = DEFAULT_BOOLEAN_FALSE_STRING;
        }
        if (this.booleanTrueString == null) {
            this.booleanTrueString = DEFAULT_BOOLEAN_TRUE_STRING;
        }
    }

    private String getColumnListStr(String[] cols) {
        if (null == cols) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String col : cols) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(this.escapeColName(col));
            first = false;
        }
        return sb.toString();
    }

    private String getSelectListColumnsStr(String[] cols, String tableName) {
        if (null == cols || tableName == null) {
            return null;
        }
        Map<String, String> columnTypes = this.getColumnTypeNamesForTable(tableName);
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String col : cols) {
            String colEscaped = this.escapeColName(col);
            if (!first) {
                sb.append(", ");
            }
            if (columnTypes.get(col) == null) {
                LOG.error((Object)("can not find " + col + " in type medatadata"));
                sb.append(col);
            } else if ("bool".equalsIgnoreCase(columnTypes.get(col))) {
                sb.append(String.format("case when %s=true then '" + this.booleanTrueString + "' when %s=false then '" + this.booleanFalseString + "' end as %s", colEscaped, colEscaped, colEscaped));
            } else if ("bit".equalsIgnoreCase(columnTypes.get(col))) {
                sb.append(String.format("case when %s=B'1' then '" + this.booleanTrueString + "' when %s=B'0' then '" + this.booleanFalseString + "' end as %s", colEscaped, colEscaped, colEscaped));
            } else {
                sb.append(colEscaped);
            }
            first = false;
        }
        return sb.toString();
    }

    private String getCopyCommand(String tableName) {
        StringBuilder sb = new StringBuilder();
        String[] cols = this.getColumnNames(tableName);
        String escapedTableName = this.escapeTableName(tableName);
        sb.append("COPY ");
        String whereClause = this.options.getWhereClause();
        if (whereClause == null || whereClause.isEmpty()) {
            whereClause = "1=1";
        }
        sb.append("(");
        sb.append("SELECT ");
        if (null != cols) {
            sb.append(this.getSelectListColumnsStr(cols, tableName));
        } else {
            sb.append("*");
        }
        sb.append(" FROM ");
        sb.append(escapedTableName);
        sb.append(" WHERE ");
        sb.append(whereClause);
        sb.append(")");
        sb.append(" TO STDOUT WITH DELIMITER E'\\");
        sb.append(Integer.toString(this.options.getOutputFieldDelim(), 8));
        sb.append("' CSV ");
        if (this.options.getNullStringValue() != null) {
            sb.append("NULL AS E'");
            sb.append(SubstitutionUtils.removeEscapeCharacters(this.options.getNullStringValue()));
            sb.append("' ");
        }
        if (this.options.getOutputEnclosedBy() != '\u0000') {
            sb.append("QUOTE E'\\");
            sb.append(Integer.toString(this.options.getOutputEnclosedBy(), 8));
            sb.append("' ");
        }
        if (this.options.getOutputEscapedBy() != '\u0000') {
            sb.append("ESCAPE E'\\");
            sb.append(Integer.toString(this.options.getOutputEscapedBy(), 8));
            sb.append("' ");
        }
        if (null != cols && this.options.isOutputEncloseRequired()) {
            sb.append("FORCE QUOTE ");
            sb.append(this.getColumnListStr(cols));
        }
        sb.append(";");
        String copyCmd = sb.toString();
        LOG.info((Object)("Copy command is " + copyCmd));
        return copyCmd;
    }

    private String writeCopyCommand(String command) throws IOException {
        String tmpDir = this.options.getTempDir();
        File tempFile = File.createTempFile("tmp-", ".sql", new File(tmpDir));
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(tempFile)));
        w.write(command);
        w.newLine();
        w.close();
        return tempFile.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importTable(ImportJobContext context) throws IOException, ImportException {
        context.setConnManager(this);
        String tableName = context.getTableName();
        SqoopOptions options = context.getOptions();
        LOG.info((Object)"Beginning psql fast path import");
        if (options.getFileLayout() != SqoopOptions.FileLayout.TextFile) {
            LOG.warn((Object)("File import layout" + (Object)((Object)options.getFileLayout()) + " is not supported by"));
            LOG.warn((Object)"Postgresql direct import; import will proceed as text files.");
        }
        if (!StringUtils.equals((String)options.getNullStringValue(), (String)options.getNullNonStringValue())) {
            throw new ImportException("Detected different values of --input-string and --input-non-string parameters. PostgreSQL direct manager do not support that. Please either use the same values or omit the --direct parameter.");
        }
        String commandFilename = null;
        String passwordFilename = null;
        Process p = null;
        AsyncSink sink = null;
        AsyncSink errSink = null;
        PerfCounters counters = new PerfCounters();
        try {
            String copyCmd = this.getCopyCommand(tableName);
            commandFilename = this.writeCopyCommand(copyCmd);
            ArrayList<String> args = new ArrayList<String>();
            List<String> envp = Executor.getCurEnvpStrings();
            String connectString = options.getConnectString();
            String databaseName = JdbcUrl.getDatabaseName(connectString);
            String hostname = JdbcUrl.getHostName(connectString);
            int port = JdbcUrl.getPort(connectString);
            if (null == databaseName) {
                throw new ImportException("Could not determine database name");
            }
            LOG.info((Object)("Performing import of table " + tableName + " from database " + databaseName));
            args.add(PSQL_CMD);
            args.add("--tuples-only");
            args.add("--quiet");
            String username = options.getUsername();
            if (username != null) {
                args.add("--username");
                args.add(username);
                String password = options.getPassword();
                if (null != password) {
                    passwordFilename = PostgreSQLUtils.writePasswordFile(options.getTempDir(), password);
                    envp.add("PGPASSFILE=" + passwordFilename);
                }
            }
            args.add("--host");
            args.add(hostname);
            if (port != -1) {
                args.add("--port");
                args.add(Integer.toString(port));
            }
            if (null != databaseName && databaseName.length() > 0) {
                args.add(databaseName);
            }
            args.add("-f");
            args.add(commandFilename);
            LOG.debug((Object)"Starting psql with arguments:");
            for (String arg : args) {
                LOG.debug((Object)("  " + arg));
            }
            SplittableBufferedWriter w = DirectImportUtils.createHdfsSink(options.getConf(), options, context);
            p = Runtime.getRuntime().exec(args.toArray(new String[0]), envp.toArray(new String[0]));
            InputStream is = p.getInputStream();
            sink = new PostgresqlAsyncSink(w, options, counters);
            LOG.debug((Object)"Starting stream sink");
            counters.startClock();
            sink.processStream(is);
            errSink = new LoggingAsyncSink(LOG);
            errSink.processStream(p.getErrorStream());
        }
        catch (Throwable throwable) {
            LOG.debug((Object)"Waiting for process completion");
            int result = 0;
            if (null != p) {
                while (true) {
                    try {
                        result = p.waitFor();
                    }
                    catch (InterruptedException ie) {
                        continue;
                    }
                    break;
                }
            }
            if (null != passwordFilename && !new File(passwordFilename).delete()) {
                LOG.error((Object)("Could not remove postgresql password file " + passwordFilename));
                LOG.error((Object)"You should remove this file to protect your credentials.");
            }
            if (null != commandFilename && !new File(commandFilename).delete()) {
                LOG.info((Object)("Could not remove temp file: " + commandFilename));
            }
            int streamResult = 0;
            if (null != sink) {
                while (true) {
                    try {
                        streamResult = sink.join();
                    }
                    catch (InterruptedException ie) {
                        continue;
                    }
                    break;
                }
            }
            if (null != errSink) {
                try {
                    if (0 != errSink.join()) {
                        LOG.info((Object)"Encountered exception reading stderr stream");
                    }
                }
                catch (InterruptedException ie) {
                    LOG.info((Object)("Thread interrupted waiting for stderr to complete: " + ie.toString()));
                }
            }
            LOG.info((Object)"Transfer loop complete.");
            if (0 != result) {
                throw new IOException("psql terminated with status " + Integer.toString(result));
            }
            if (0 != streamResult) {
                throw new IOException("Encountered exception in stream sink");
            }
            counters.stopClock();
            LOG.info((Object)("Transferred " + counters.toString()));
            throw throwable;
        }
        LOG.debug((Object)"Waiting for process completion");
        int result = 0;
        if (null != p) {
            while (true) {
                try {
                    result = p.waitFor();
                }
                catch (InterruptedException ie) {
                    continue;
                }
                break;
            }
        }
        if (null != passwordFilename && !new File(passwordFilename).delete()) {
            LOG.error((Object)("Could not remove postgresql password file " + passwordFilename));
            LOG.error((Object)"You should remove this file to protect your credentials.");
        }
        if (null != commandFilename && !new File(commandFilename).delete()) {
            LOG.info((Object)("Could not remove temp file: " + commandFilename));
        }
        int streamResult = 0;
        if (null != sink) {
            while (true) {
                try {
                    streamResult = sink.join();
                }
                catch (InterruptedException ie) {
                    continue;
                }
                break;
            }
        }
        if (null != errSink) {
            try {
                if (0 != errSink.join()) {
                    LOG.info((Object)"Encountered exception reading stderr stream");
                }
            }
            catch (InterruptedException ie) {
                LOG.info((Object)("Thread interrupted waiting for stderr to complete: " + ie.toString()));
            }
        }
        LOG.info((Object)"Transfer loop complete.");
        if (0 != result) {
            throw new IOException("psql terminated with status " + Integer.toString(result));
        }
        if (0 != streamResult) {
            throw new IOException("Encountered exception in stream sink");
        }
        counters.stopClock();
        LOG.info((Object)("Transferred " + counters.toString()));
    }

    @Override
    public boolean supportsStagingForExport() {
        return true;
    }

    @Override
    protected void applyExtraArguments(CommandLine cmdLine) {
        String arg;
        super.applyExtraArguments(cmdLine);
        if (cmdLine.hasOption(BOOLEAN_TRUE_STRING)) {
            arg = cmdLine.getOptionValue(BOOLEAN_TRUE_STRING);
            LOG.info((Object)("Loaded TRUE encoding string " + arg));
            this.booleanTrueString = arg;
        }
        if (cmdLine.hasOption(BOOLEAN_FALSE_STRING)) {
            arg = cmdLine.getOptionValue(BOOLEAN_FALSE_STRING);
            LOG.info((Object)("Loaded FALSE encoding string " + arg));
            this.booleanFalseString = arg;
        }
    }

    @Override
    protected RelatedOptions getExtraOptions() {
        RelatedOptions extraOptions = super.getExtraOptions();
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"String to encode TRUE value");
        OptionBuilder.withLongOpt((String)BOOLEAN_TRUE_STRING);
        extraOptions.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"String to encode FALSE value");
        OptionBuilder.withLongOpt((String)BOOLEAN_FALSE_STRING);
        extraOptions.addOption(OptionBuilder.create());
        return extraOptions;
    }

    @Override
    public void exportTable(ExportJobContext context) throws IOException, ExportException {
        context.setConnManager(this);
        PostgreSQLCopyExportJob job = new PostgreSQLCopyExportJob(context, null, ExportInputFormat.class, NullOutputFormat.class);
        job.runExport();
    }

    static class PostgresqlAsyncSink
    extends ErrorableAsyncSink {
        private final SplittableBufferedWriter writer;
        private final PerfCounters counters;
        private final SqoopOptions options;

        PostgresqlAsyncSink(SplittableBufferedWriter w, SqoopOptions opts, PerfCounters ctrs) {
            this.writer = w;
            this.options = opts;
            this.counters = ctrs;
        }

        @Override
        public void processStream(InputStream is) {
            this.child = new PostgresqlStreamThread(is, this.writer, this.options, this.counters);
            this.child.start();
        }

        private static class PostgresqlStreamThread
        extends ErrorableThread {
            public static final Log LOG = LogFactory.getLog((String)PostgresqlStreamThread.class.getName());
            private final SplittableBufferedWriter writer;
            private final InputStream stream;
            private final SqoopOptions options;
            private final PerfCounters counters;

            PostgresqlStreamThread(InputStream is, SplittableBufferedWriter w, SqoopOptions opts, PerfCounters ctrs) {
                this.stream = is;
                this.writer = w;
                this.options = opts;
                this.counters = ctrs;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedReader r = null;
                SplittableBufferedWriter w = this.writer;
                char recordDelim = this.options.getOutputRecordDelim();
                try {
                    String inLine;
                    r = new BufferedReader(new InputStreamReader(this.stream));
                    while (null != (inLine = r.readLine())) {
                        w.write(inLine);
                        w.write(recordDelim);
                        w.allowSplit();
                        this.counters.addBytes(1 + inLine.length());
                    }
                }
                catch (IOException ioe) {
                    LOG.error((Object)("IOException reading from psql: " + ioe.toString()));
                    this.setError();
                }
                finally {
                    if (null != r) {
                        try {
                            r.close();
                        }
                        catch (IOException ioe) {
                            LOG.info((Object)("Error closing FIFO stream: " + ioe.toString()));
                        }
                    }
                    if (null != w) {
                        try {
                            w.close();
                        }
                        catch (IOException ioe) {
                            LOG.info((Object)("Error closing HDFS stream: " + ioe.toString()));
                        }
                    }
                }
            }
        }
    }
}

