/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public enum SupportedManagers {
    MYSQL("jdbc:mysql:", true),
    POSTGRES("jdbc:postgresql:", true),
    HSQLDB("jdbc:hsqldb:", false),
    ORACLE("jdbc:oracle:", true),
    SQLSERVER("jdbc:sqlserver:", false),
    JTDS_SQLSERVER("jdbc:jtds:sqlserver:", false),
    DB2("jdbc:db2:", false),
    NETEZZA("jdbc:netezza:", true),
    CUBRID("jdbc:cubrid:", false);

    private final String schemePrefix;
    private final boolean hasDirectConnector;
    private static final Log LOG;

    private SupportedManagers(String schemePrefix, boolean hasDirectConnector) {
        this.schemePrefix = schemePrefix;
        this.hasDirectConnector = hasDirectConnector;
    }

    public String getSchemePrefix() {
        return this.schemePrefix;
    }

    public boolean hasDirectConnector() {
        return this.hasDirectConnector;
    }

    public boolean isTheManagerTypeOf(SqoopOptions options) {
        return SupportedManagers.extractScheme(options).startsWith(this.getSchemePrefix());
    }

    public static SupportedManagers createFrom(SqoopOptions options) {
        String scheme = SupportedManagers.extractScheme(options);
        for (SupportedManagers m : SupportedManagers.values()) {
            if (!scheme.startsWith(m.getSchemePrefix())) continue;
            return m;
        }
        return null;
    }

    static String extractScheme(SqoopOptions options) {
        String connectStr = options.getConnectString();
        int schemeStopIdx = connectStr.indexOf("//");
        if (-1 == schemeStopIdx && -1 == (schemeStopIdx = connectStr.lastIndexOf(58))) {
            LOG.warn((Object)"Could not determine scheme component of connect string");
            schemeStopIdx = connectStr.length();
        }
        return connectStr.substring(0, schemeStopIdx);
    }

    static {
        LOG = LogFactory.getLog(SupportedManagers.class);
    }
}

