/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format.orc;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.log4j.Logger;
import org.apache.orc.OrcFile;
import org.apache.orc.TypeDescription;
import org.apache.orc.Writer;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.plugins.IValueMetaConverter;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.row.value.ValueMetaBigNumber;
import org.pentaho.di.core.row.value.ValueMetaBinary;
import org.pentaho.di.core.row.value.ValueMetaBoolean;
import org.pentaho.di.core.row.value.ValueMetaConversionException;
import org.pentaho.di.core.row.value.ValueMetaConverter;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaInternetAddress;
import org.pentaho.di.core.row.value.ValueMetaNumber;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.row.value.ValueMetaTimestamp;
import org.pentaho.hadoop.shim.api.format.IOrcOutputField;
import org.pentaho.hadoop.shim.api.format.IPentahoOutputFormat;
import org.pentaho.hadoop.shim.common.format.S3NCredentialUtils;

public class PentahoOrcRecordWriter
implements IPentahoOutputFormat.IPentahoRecordWriter {
    private final TypeDescription schema;
    private VectorizedRowBatch batch;
    private int batchRowNumber;
    private Writer writer;
    private final IValueMetaConverter valueMetaConverter = new ValueMetaConverter();
    private final String dateFormatString = ValueMetaBase.DEFAULT_DATE_FORMAT_MASK;
    private SimpleDateFormat datePattern = new SimpleDateFormat(this.dateFormatString);
    private RowMeta outputRowMeta = new RowMeta();
    private RowMetaAndData outputRowMetaAndData;
    private static final Logger logger = Logger.getLogger(PentahoOrcRecordWriter.class);
    private List<? extends IOrcOutputField> fields;

    public PentahoOrcRecordWriter(List<? extends IOrcOutputField> fields, TypeDescription schema, String filePath, Configuration conf) {
        this.fields = fields;
        this.schema = schema;
        AtomicInteger fieldNumber = new AtomicInteger();
        fields.forEach(field -> this.setOutputMeta(fieldNumber, (IOrcOutputField)field));
        this.outputRowMetaAndData = new RowMetaAndData((RowMetaInterface)this.outputRowMeta, new Object[fieldNumber.get()]);
        try {
            S3NCredentialUtils.applyS3CredentialsToHadoopConfigurationIfNecessary(filePath, conf);
            Path outputFile = new Path(S3NCredentialUtils.scrubFilePathIfNecessary(filePath));
            this.writer = OrcFile.createWriter((Path)outputFile, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)conf).setSchema(schema));
            this.batch = schema.createRowBatch();
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
    }

    private void setOutputMeta(AtomicInteger fieldNumber, IOrcOutputField field) {
        this.outputRowMeta.addValueMeta(this.getValueMetaInterface(field.getPentahoFieldName(), field.getOrcType().getPdiType()));
        fieldNumber.getAndIncrement();
    }

    public void write(RowMetaAndData row) throws Exception {
        AtomicInteger fieldNumber = new AtomicInteger();
        this.batchRowNumber = this.batch.size++;
        this.fields.forEach(field -> this.setFieldValue(fieldNumber, (IOrcOutputField)field, row));
        if (this.batch.size == this.batch.getMaxSize() - 1) {
            this.writer.addRowBatch(this.batch);
            this.batch.reset();
        }
    }

    private void setFieldValue(AtomicInteger fieldNumber, IOrcOutputField field, RowMetaAndData rowMetaAndData) {
        int fieldNo = fieldNumber.getAndIncrement();
        ColumnVector columnVector = this.batch.cols[fieldNo];
        int rowMetaIndex = rowMetaAndData.getRowMeta().indexOfValue(field.getPentahoFieldName());
        if (rowMetaAndData.getData()[rowMetaIndex] == null && field.getAllowNull()) {
            columnVector.isNull[this.batchRowNumber] = true;
            columnVector.noNulls = false;
            return;
        }
        columnVector.isNull[this.batchRowNumber] = false;
        int inlineType = rowMetaAndData.getRowMeta().getValueMeta(rowMetaIndex).getType();
        Object inlineValue = rowMetaAndData.getData()[rowMetaIndex];
        Object setValue = null;
        try {
            setValue = this.valueMetaConverter.convertFromSourceToTargetDataType(inlineType, field.getOrcType().getPdiType(), inlineValue);
        }
        catch (ValueMetaConversionException e) {
            logger.error((Object)e);
        }
        this.outputRowMetaAndData.getData()[rowMetaIndex] = setValue;
        switch (field.getOrcType()) {
            case BOOLEAN: {
                try {
                    ((LongColumnVector)columnVector).vector[this.batchRowNumber] = rowMetaAndData.getBoolean(field.getPentahoFieldName(), field.getDefaultValue() != null ? Boolean.valueOf(field.getDefaultValue()) : false) ? 1L : 0L;
                }
                catch (KettleValueException e) {
                    logger.error((Object)e);
                }
                break;
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                try {
                    ((LongColumnVector)columnVector).vector[this.batchRowNumber] = rowMetaAndData.getInteger(field.getPentahoFieldName(), field.getDefaultValue() != null ? Long.valueOf(field.getDefaultValue()) : 0L);
                }
                catch (KettleValueException e) {
                    logger.error((Object)e);
                }
                break;
            }
            case BINARY: {
                try {
                    this.setBytesColumnVector((BytesColumnVector)columnVector, rowMetaAndData.getBinary(field.getPentahoFieldName(), field.getDefaultValue() != null ? field.getDefaultValue().getBytes() : new byte[]{}));
                }
                catch (KettleValueException e) {
                    logger.error((Object)e);
                }
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                try {
                    double number = rowMetaAndData.getNumber(field.getPentahoFieldName(), (field.getDefaultValue() != null ? new Double(field.getDefaultValue()) : new Double(0.0)).doubleValue());
                    ((DoubleColumnVector)columnVector).vector[this.batchRowNumber] = number = this.applyScale(number, field);
                }
                catch (KettleValueException e) {
                    logger.error((Object)e);
                }
                break;
            }
            case DECIMAL: {
                try {
                    ((DecimalColumnVector)columnVector).vector[this.batchRowNumber] = new HiveDecimalWritable(HiveDecimal.create((BigDecimal)rowMetaAndData.getBigNumber(field.getPentahoFieldName(), field.getDefaultValue() != null ? new BigDecimal(field.getDefaultValue()) : new BigDecimal(0))));
                }
                catch (KettleValueException e) {
                    logger.error((Object)e);
                }
                break;
            }
            case CHAR: 
            case VARCHAR: 
            case STRING: {
                try {
                    this.setBytesColumnVector((BytesColumnVector)columnVector, rowMetaAndData.getString(field.getPentahoFieldName(), field.getDefaultValue() != null ? field.getDefaultValue() : ""));
                }
                catch (KettleValueException e) {
                    logger.error((Object)e);
                }
                break;
            }
            case DATE: {
                try {
                    String conversionMask = rowMetaAndData.getValueMeta(rowMetaIndex).getConversionMask();
                    if (conversionMask == null) {
                        conversionMask = "yyyy/MM/dd HH:mm:ss.SSS";
                    }
                    SimpleDateFormat dateFormat = new SimpleDateFormat(conversionMask);
                    Date defaultDate = field.getDefaultValue() != null ? dateFormat.parse(field.getDefaultValue()) : new Date(0L);
                    Date date = rowMetaAndData.getDate(field.getPentahoFieldName(), defaultDate);
                    ((LongColumnVector)columnVector).vector[this.batchRowNumber] = this.getOrcDate(date, rowMetaAndData.getValueMeta(rowMetaIndex).getDateFormatTimeZone());
                }
                catch (ParseException | KettleValueException e) {
                    logger.error((Object)e);
                }
                break;
            }
            case TIMESTAMP: {
                try {
                    String conversionMask = rowMetaAndData.getValueMeta(rowMetaIndex).getConversionMask();
                    if (conversionMask == null) {
                        conversionMask = "yyyy/MM/dd HH:mm:ss.SSS";
                    }
                    SimpleDateFormat dateFormat = new SimpleDateFormat(conversionMask);
                    ((TimestampColumnVector)columnVector).set(this.batchRowNumber, new Timestamp(rowMetaAndData.getDate(field.getPentahoFieldName(), field.getDefaultValue() != null ? dateFormat.parse(field.getDefaultValue()) : new Date(0L)).getTime()));
                }
                catch (ParseException | KettleValueException e) {
                    logger.error((Object)e);
                }
                break;
            }
            default: {
                throw new RuntimeException("Field: " + field.getDefaultValue() + "  Undefined type: " + field.getOrcType().getName());
            }
        }
    }

    private double applyScale(double number, IOrcOutputField outputField) {
        if (outputField.getScale() > 0) {
            BigDecimal bd = new BigDecimal(number);
            bd = bd.setScale(outputField.getScale(), 4);
            number = bd.doubleValue();
        }
        return number;
    }

    private int getOrcDate(Date date, TimeZone timeZone) {
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        LocalDate rowDate = date.toInstant().atZone(timeZone.toZoneId()).toLocalDate();
        return Math.toIntExact(ChronoUnit.DAYS.between(LocalDate.ofEpochDay(0L), rowDate));
    }

    private void setBytesColumnVector(BytesColumnVector bytesColumnVector, String value) {
        if (value == null) {
            this.setBytesColumnVector(bytesColumnVector, new byte[0]);
        } else {
            this.setBytesColumnVector(bytesColumnVector, value.getBytes());
        }
    }

    private void setBytesColumnVector(BytesColumnVector bytesColumnVector, byte[] value) {
        bytesColumnVector.vector[this.batchRowNumber] = value;
        bytesColumnVector.start[this.batchRowNumber] = 0;
        bytesColumnVector.length[this.batchRowNumber] = value.length;
    }

    public void close() throws IOException {
        if (this.batch.size > 0) {
            this.writer.addRowBatch(this.batch);
        }
        this.writer.close();
    }

    private ByteBuffer toByteBuffer(int i) throws UnsupportedEncodingException {
        return this.toByteBuffer(String.valueOf(i));
    }

    private ByteBuffer toByteBuffer(String s) throws UnsupportedEncodingException {
        return ByteBuffer.wrap(s.getBytes("UTF-8"));
    }

    private ByteBuffer toByteBuffer(boolean b) throws UnsupportedEncodingException {
        return ByteBuffer.wrap(String.valueOf(b).getBytes("UTF-8"));
    }

    private ValueMetaInterface getValueMetaInterface(String fieldName, int fieldType) {
        switch (fieldType) {
            case 10: {
                return new ValueMetaInternetAddress(fieldName);
            }
            case 2: {
                return new ValueMetaString(fieldName);
            }
            case 5: {
                return new ValueMetaInteger(fieldName);
            }
            case 1: {
                return new ValueMetaNumber(fieldName);
            }
            case 6: {
                return new ValueMetaBigNumber(fieldName);
            }
            case 9: {
                return new ValueMetaTimestamp(fieldName);
            }
            case 3: {
                return new ValueMetaDate(fieldName);
            }
            case 4: {
                return new ValueMetaBoolean(fieldName);
            }
            case 8: {
                return new ValueMetaBinary(fieldName);
            }
        }
        return null;
    }
}

