/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.repository.support;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.querydsl.QueryDslPredicateExecutor;
import org.springframework.data.querydsl.QueryDslUtils;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.repository.query.AnnotatedLdapRepositoryQuery;
import org.springframework.ldap.repository.query.LdapQueryMethod;
import org.springframework.ldap.repository.query.PartTreeLdapRepositoryQuery;
import org.springframework.ldap.repository.support.QueryDslLdapRepository;
import org.springframework.ldap.repository.support.SimpleLdapRepository;

public class LdapRepositoryFactory
extends RepositoryFactorySupport {
    private final LdapOperations ldapOperations;

    public LdapRepositoryFactory(LdapOperations ldapOperations) {
        this.ldapOperations = ldapOperations;
    }

    public <T, ID extends Serializable> EntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        return null;
    }

    protected Object getTargetRepository(RepositoryMetadata metadata) {
        if (!LdapRepositoryFactory.isQueryDslRepository(metadata.getRepositoryInterface())) {
            return new SimpleLdapRepository(this.ldapOperations, this.ldapOperations.getObjectDirectoryMapper(), metadata.getDomainType());
        }
        return new QueryDslLdapRepository(this.ldapOperations, this.ldapOperations.getObjectDirectoryMapper(), metadata.getDomainType());
    }

    protected Object getTargetRepository(RepositoryInformation metadata) {
        return this.getTargetRepository((RepositoryMetadata)metadata);
    }

    private static boolean isQueryDslRepository(Class<?> repositoryInterface) {
        return QueryDslUtils.QUERY_DSL_PRESENT && QueryDslPredicateExecutor.class.isAssignableFrom(repositoryInterface);
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        if (!LdapRepositoryFactory.isQueryDslRepository(metadata.getRepositoryInterface())) {
            return SimpleLdapRepository.class;
        }
        return QueryDslLdapRepository.class;
    }

    protected QueryLookupStrategy getQueryLookupStrategy(QueryLookupStrategy.Key key) {
        return new LdapQueryLookupStrategy();
    }

    private final class LdapQueryLookupStrategy
    implements QueryLookupStrategy {
        private LdapQueryLookupStrategy() {
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            LdapQueryMethod queryMethod = new LdapQueryMethod(method, metadata, factory);
            Class domainType = metadata.getDomainType();
            if (queryMethod.hasQueryAnnotation()) {
                return new AnnotatedLdapRepositoryQuery(queryMethod, domainType, LdapRepositoryFactory.this.ldapOperations);
            }
            return new PartTreeLdapRepositoryQuery(queryMethod, domainType, LdapRepositoryFactory.this.ldapOperations);
        }
    }
}

