/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.actors;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public interface ArtemisExecutor
extends Executor {
    public static ArtemisExecutor delegate(final Executor executor) {
        return new ArtemisExecutor(){

            @Override
            public void execute(Runnable command) {
                executor.execute(command);
            }
        };
    }

    default public int shutdownNow(Consumer<? super Runnable> onPendingTask) {
        return 0;
    }

    default public boolean flush(long timeout, TimeUnit unit) {
        CountDownLatch latch = new CountDownLatch(1);
        this.execute(latch::countDown);
        try {
            return latch.await(timeout, unit);
        }
        catch (Exception e) {
            return false;
        }
    }

    default public int shutdownNow() {
        return this.shutdownNow(t -> {});
    }

    default public void shutdown() {
    }

    default public boolean isFlushed() {
        final CountDownLatch latch = new CountDownLatch(1);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                latch.countDown();
            }
        };
        this.execute(runnable);
        try {
            return latch.await(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }
}

