/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.BackupInfo;
import org.apache.hadoop.hbase.backup.impl.BackupManager;
import org.apache.hadoop.hbase.backup.impl.BackupSystemTable;
import org.apache.hadoop.hbase.backup.util.BackupClientUtil;
import org.apache.hadoop.hbase.backup.util.BackupServerUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class IncrementalBackupManager {
    public static final Log LOG = LogFactory.getLog(IncrementalBackupManager.class);
    private final BackupManager backupManager;
    private final Configuration conf;
    private final Connection conn;

    public IncrementalBackupManager(BackupManager bm) {
        this.backupManager = bm;
        this.conf = bm.getConf();
        this.conn = bm.getConnection();
    }

    public HashMap<String, Long> getIncrBackupLogFileList(BackupInfo backupContext) throws IOException {
        String savedStartCode = this.backupManager.readBackupStartCode();
        HashMap<TableName, HashMap<String, Long>> previousTimestampMap = this.backupManager.readLogTimestampMap();
        HashMap<String, Long> previousTimestampMins = BackupServerUtil.getRSLogTimestampMins(previousTimestampMap);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("StartCode " + savedStartCode + "for backupID " + backupContext.getBackupId()));
        }
        if (savedStartCode == null || previousTimestampMins == null || previousTimestampMins.isEmpty()) {
            throw new IOException("Cannot read any previous back up timestamps from hbase:backup. In order to create an incremental backup, at least one full backup is needed.");
        }
        try (Admin admin = this.conn.getAdmin();){
            LOG.info((Object)"Execute roll log procedure for incremental backup ...");
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("backupRoot", backupContext.getTargetRootDir());
            admin.execProcedure("rolllog-proc", "rolllog", props);
        }
        HashMap<String, Long> newTimestamps = this.backupManager.readRegionServerLastLogRollResult();
        List<String> logList = this.getLogFilesForNewBackup(previousTimestampMins, newTimestamps, this.conf, savedStartCode);
        List<BackupSystemTable.WALItem> logFromSystemTable = this.getLogFilesFromBackupSystem(previousTimestampMins, newTimestamps, this.backupManager.getBackupContext().getTargetRootDir());
        this.addLogsFromBackupSystemToContext(logFromSystemTable);
        logList = this.excludeAlreadyBackedUpWALs(logList, logFromSystemTable);
        backupContext.setIncrBackupFileList(logList);
        return newTimestamps;
    }

    private List<String> excludeAlreadyBackedUpWALs(List<String> logList, List<BackupSystemTable.WALItem> logFromSystemTable) {
        List<String> backupedWALList = this.toWALList(logFromSystemTable);
        logList.removeAll(backupedWALList);
        return logList;
    }

    private List<String> toWALList(List<BackupSystemTable.WALItem> logFromSystemTable) {
        ArrayList<String> list = new ArrayList<String>(logFromSystemTable.size());
        for (BackupSystemTable.WALItem item : logFromSystemTable) {
            list.add(item.getWalFile());
        }
        return list;
    }

    private void addLogsFromBackupSystemToContext(List<BackupSystemTable.WALItem> logFromSystemTable) {
        ArrayList<String> walFiles = new ArrayList<String>();
        for (BackupSystemTable.WALItem item : logFromSystemTable) {
            Path p = new Path(item.getWalFile());
            String walFileName = p.getName();
            String backupId = item.getBackupId();
            String relWALPath = backupId + "/" + walFileName;
            walFiles.add(relWALPath);
        }
    }

    private List<BackupSystemTable.WALItem> getLogFilesFromBackupSystem(HashMap<String, Long> olderTimestamps, HashMap<String, Long> newestTimestamps, String backupRoot) throws IOException {
        ArrayList<BackupSystemTable.WALItem> logFiles = new ArrayList<BackupSystemTable.WALItem>();
        Iterator<BackupSystemTable.WALItem> it = this.backupManager.getWALFilesFromBackupSystem();
        while (it.hasNext()) {
            String walFileName;
            String server;
            BackupSystemTable.WALItem item = it.next();
            String rootDir = item.getBackupRoot();
            if (!rootDir.equals(backupRoot) || (server = BackupServerUtil.parseHostNameFromLogFile(new Path(walFileName = item.getWalFile()))) == null) continue;
            Long tss = this.getTimestamp(walFileName);
            Long oldTss = olderTimestamps.get(server);
            Long newTss = newestTimestamps.get(server);
            if (oldTss == null) {
                logFiles.add(item);
                continue;
            }
            if (newTss == null) {
                newTss = Long.MAX_VALUE;
            }
            if (tss <= oldTss || tss >= newTss) continue;
            logFiles.add(item);
        }
        return logFiles;
    }

    private Long getTimestamp(String walFileName) {
        int index = walFileName.lastIndexOf(".");
        return Long.parseLong(walFileName.substring(index + 1));
    }

    private List<String> getLogFilesForNewBackup(HashMap<String, Long> olderTimestamps, HashMap<String, Long> newestTimestamps, Configuration conf, String savedStartCode) throws IOException {
        FileStatus[] oldlogs;
        Long currentLogTS;
        String currentLogFile;
        Long oldTimeStamp;
        String host;
        Path p;
        FileStatus[] rss;
        LOG.debug((Object)("In getLogFilesForNewBackup()\nolderTimestamps: " + olderTimestamps + "\n newestTimestamps: " + newestTimestamps));
        Path rootdir = FSUtils.getRootDir(conf);
        Path logDir = new Path(rootdir, "WALs");
        Path oldLogDir = new Path(rootdir, "oldWALs");
        FileSystem fs = rootdir.getFileSystem(conf);
        NewestLogFilter pathFilter = new NewestLogFilter();
        ArrayList<String> resultLogFiles = new ArrayList<String>();
        ArrayList<String> newestLogs = new ArrayList<String>();
        for (FileStatus rs : rss = fs.listStatus(logDir)) {
            FileStatus[] logs;
            p = rs.getPath();
            host = BackupServerUtil.parseHostNameFromLogFile(p);
            if (host == null) {
                LOG.warn((Object)("Skipping " + p + " not a valid log file"));
                continue;
            }
            oldTimeStamp = olderTimestamps.get(host);
            if (oldTimeStamp == null) {
                logs = fs.listStatus(p);
            } else {
                pathFilter.setLastBackupTS(oldTimeStamp);
                logs = fs.listStatus(p, (PathFilter)pathFilter);
            }
            for (FileStatus log : logs) {
                LOG.debug((Object)("currentLogFile: " + log.getPath().toString()));
                if (DefaultWALProvider.isMetaFile(log.getPath())) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Skip hbase:meta log file: " + log.getPath().getName()));
                    continue;
                }
                currentLogFile = log.getPath().toString();
                resultLogFiles.add(currentLogFile);
                currentLogTS = BackupClientUtil.getCreationTime((Path)log.getPath());
                if (Long.valueOf(currentLogTS) <= Long.valueOf(newestTimestamps.get(host))) continue;
                newestLogs.add(currentLogFile);
            }
        }
        for (FileStatus oldlog : oldlogs = fs.listStatus(oldLogDir)) {
            p = oldlog.getPath();
            currentLogFile = p.toString();
            if (DefaultWALProvider.isMetaFile(p)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Skip .meta log file: " + currentLogFile));
                continue;
            }
            host = BackupClientUtil.parseHostFromOldLog((Path)p);
            if (host == null) {
                LOG.debug((Object)("Skip file: " + currentLogFile));
                continue;
            }
            currentLogTS = BackupClientUtil.getCreationTime((Path)p);
            oldTimeStamp = olderTimestamps.get(host);
            if (oldTimeStamp == null) {
                if (Long.valueOf(currentLogTS) < Long.valueOf(savedStartCode)) continue;
                resultLogFiles.add(currentLogFile);
            } else if (Long.valueOf(currentLogTS) > Long.valueOf(oldTimeStamp)) {
                resultLogFiles.add(currentLogFile);
            }
            Long newTimestamp = newestTimestamps.get(host);
            if (newTimestamp == null || Long.valueOf(currentLogTS) <= Long.valueOf(newTimestamp)) continue;
            newestLogs.add(currentLogFile);
        }
        resultLogFiles.removeAll(newestLogs);
        return resultLogFiles;
    }

    class NewestLogFilter
    implements PathFilter {
        private Long lastBackupTS = 0L;

        protected void setLastBackupTS(Long ts) {
            this.lastBackupTS = ts;
        }

        public boolean accept(Path path) {
            if (DefaultWALProvider.isMetaFile(path)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Skip .meta log file: " + path.getName()));
                }
                return false;
            }
            Long timestamp = null;
            try {
                timestamp = BackupClientUtil.getCreationTime((Path)path);
                return timestamp > Long.valueOf(this.lastBackupTS);
            }
            catch (Exception e) {
                LOG.warn((Object)("Cannot read timestamp of log file " + path + ", skip it"));
                return false;
            }
        }
    }
}

