/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.mapreduce;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.IncrementalRestoreService;
import org.apache.hadoop.hbase.backup.util.BackupServerUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class MapReduceRestoreService
implements IncrementalRestoreService {
    public static final Log LOG = LogFactory.getLog(MapReduceRestoreService.class);
    private Configuration conf;

    @Override
    public void run(Path[] fileDirPaths, TableName[] tableNames, TableName[] newTableNames) throws IOException {
        String logDirs = StringUtils.join((Object[])fileDirPaths, (String)",");
        LOG.info((Object)("Restore incremental backup from directory " + logDirs + " from hbase tables " + BackupServerUtil.join(tableNames) + " to tables " + BackupServerUtil.join(newTableNames)));
        for (int i = 0; i < tableNames.length; ++i) {
            LOG.info((Object)("Restore " + tableNames[i] + " into " + newTableNames[i]));
            int result = 0;
            int loaderResult = 0;
            try {
                for (Path bulkOutputPath : fileDirPaths) {
                    String[] args;
                    LoadIncrementalHFiles loader = MapReduceRestoreService.createLoader(this.conf);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Restoring HFiles from directory " + bulkOutputPath));
                    }
                    if (!this.failed(loaderResult = loader.run(args = new String[]{bulkOutputPath.toString(), newTableNames[i].getNameAsString()}))) continue;
                    throw new IOException("Can not restore from backup directory " + logDirs + " (check Hadoop and HBase logs). Bulk loader return code =" + loaderResult);
                }
                LOG.debug((Object)("Restore Job finished:" + result));
                continue;
            }
            catch (Exception e) {
                throw new IOException("Can not restore from backup directory " + logDirs + " (check Hadoop and HBase logs) ", e);
            }
        }
    }

    private boolean failed(int result) {
        return result != 0;
    }

    public static LoadIncrementalHFiles createLoader(Configuration conf) throws IOException {
        Integer milliSecInHour = 3600000;
        conf.setInt("hbase.rpc.timeout", milliSecInHour.intValue());
        conf.setInt("hbase.mapreduce.bulkload.max.hfiles.perRegion.perFamily", Integer.MAX_VALUE);
        LoadIncrementalHFiles loader = null;
        try {
            loader = new LoadIncrementalHFiles(conf);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return loader;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }
}

