/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.packager.origin;

import org.apache.commons.lang.StringUtils;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.context.api.IUrlProvider;
import pt.webdetails.cpf.packager.origin.PathOrigin;
import pt.webdetails.cpf.repository.api.IContentAccessFactory;
import pt.webdetails.cpf.repository.api.IReadAccess;

public class OtherPluginStaticSystemOrigin
extends PathOrigin {
    private String pluginId;

    public OtherPluginStaticSystemOrigin(String pluginId, String basePath) {
        super(basePath);
        assert (pluginId != null);
        this.pluginId = pluginId;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    @Override
    public String getUrl(String localPath, IUrlProvider urlProvider) {
        return Util.joinPath(urlProvider.getPluginStaticBaseUrl(this.pluginId), this.basePath, localPath);
    }

    @Override
    public IReadAccess getReader(IContentAccessFactory factory) {
        return factory.getOtherPluginSystemReader(this.pluginId, this.basePath);
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && other instanceof OtherPluginStaticSystemOrigin && StringUtils.equals((String)this.pluginId, (String)((OtherPluginStaticSystemOrigin)other).pluginId);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash *= 73;
        return hash += this.pluginId.hashCode();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.pluginId + ":" + this.basePath;
    }
}

