/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.utils;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractCorsUtil {
    private static final String TRUE = "true";
    private static final String ORIGIN = "ORIGIN";
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    private static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";

    protected abstract boolean isCorsAllowed();

    protected abstract Collection<String> getDomainWhitelist();

    public void setCorsHeaders(HttpServletRequest request, HttpServletResponse response) {
        String origin;
        if (this.isCorsAllowed() && this.isDomainAllowed(origin = request.getHeader(ORIGIN))) {
            response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN, origin);
            response.setHeader(ACCESS_CONTROL_ALLOW_CREDENTIALS, TRUE);
        }
    }

    private boolean isDomainAllowed(String untrustedDomain) {
        if (StringUtils.isBlank((String)untrustedDomain)) {
            return false;
        }
        Collection<String> domainWhitelist = this.getDomainWhitelist();
        if (domainWhitelist == null || domainWhitelist.isEmpty()) {
            return false;
        }
        for (String domain : domainWhitelist) {
            if (!StringUtils.equalsIgnoreCase((String)domain, (String)untrustedDomain)) continue;
            return true;
        }
        return false;
    }
}

