/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import pt.webdetails.cpf.messaging.JsonSerializable;
import pt.webdetails.cpf.utils.CharsetHelper;

public class PluginIOUtils {
    private static final String ENCODING = CharsetHelper.getEncoding();
    private static Log logger = LogFactory.getLog(PluginIOUtils.class);
    private static String WRITE_MESSAGE = "Error writing output";
    private static String JSON_MESSAGE = "Error getting Json";

    private static String getEncoding() {
        return ENCODING;
    }

    public static void writeOut(OutputStream out, String data) {
        try {
            IOUtils.write((String)data, (OutputStream)out, (String)PluginIOUtils.getEncoding());
        }
        catch (IOException ex) {
            logger.error((Object)WRITE_MESSAGE, (Throwable)ex);
        }
    }

    public static void writeOut(OutputStream out, InputStream data) {
        try {
            IOUtils.copy((InputStream)data, (OutputStream)out);
        }
        catch (IOException ex) {
            logger.error((Object)WRITE_MESSAGE, (Throwable)ex);
        }
    }

    public static void writeOut(OutputStream out, JsonSerializable data) {
        try {
            IOUtils.write((String)data.toJSON().toString(), (OutputStream)out, (String)PluginIOUtils.getEncoding());
        }
        catch (IOException ex) {
            logger.error((Object)WRITE_MESSAGE, (Throwable)ex);
        }
        catch (JSONException ex) {
            logger.error((Object)JSON_MESSAGE, (Throwable)ex);
        }
    }

    public static void writeOutAndFlush(OutputStream out, String data) {
        PluginIOUtils.writeOut(out, data);
        PluginIOUtils.flush(out);
    }

    public static void writeOutAndFlush(OutputStream out, InputStream data) {
        PluginIOUtils.writeOut(out, data);
        PluginIOUtils.flush(out);
    }

    public static void writeOutAndFlush(OutputStream out, JsonSerializable data) {
        PluginIOUtils.writeOut(out, data);
        PluginIOUtils.flush(out);
    }

    private static void flush(OutputStream out) {
        try {
            if (out != null) {
                out.flush();
            }
        }
        catch (IOException ex) {
            logger.error((Object)WRITE_MESSAGE, (Throwable)ex);
        }
    }
}

