/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.server.namenode.AuthorizationProvider;
import org.apache.hadoop.hdfs.server.namenode.CachePool;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;

class FSPermissionChecker {
    static final Log LOG = LogFactory.getLog(UserGroupInformation.class);
    private final UserGroupInformation ugi;
    private final String user;
    private final Set<String> groups;
    private final boolean isSuper;

    private String toAccessControlString(INode inode, int snapshotId, FsAction access, FsPermission mode) {
        StringBuilder sb = new StringBuilder("Permission denied: ").append("user=").append(this.user).append(", ").append("access=").append(access).append(", ").append("inode=\"").append(inode.getFullPathName()).append("\":").append(inode.getUserName(snapshotId)).append(':').append(inode.getGroupName(snapshotId)).append(':').append(inode.isDirectory() ? (char)'d' : '-').append(mode);
        return sb.toString();
    }

    FSPermissionChecker(String fsOwner, String supergroup, UserGroupInformation callerUgi) {
        this.ugi = callerUgi;
        HashSet<String> s = new HashSet<String>(Arrays.asList(this.ugi.getGroupNames()));
        this.groups = Collections.unmodifiableSet(s);
        this.user = this.ugi.getShortUserName();
        this.isSuper = this.user.equals(fsOwner) || this.groups.contains(supergroup);
    }

    public boolean containsGroup(String group) {
        return this.groups.contains(group);
    }

    public String getUser() {
        return this.user;
    }

    public boolean isSuperUser() {
        return this.isSuper;
    }

    public void checkSuperuserPrivilege() throws AccessControlException {
        if (!this.isSuper) {
            throw new AccessControlException("Access denied for user " + this.user + ". Superuser privilege is required");
        }
    }

    void checkPermission(String path, FSDirectory dir, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess, boolean ignoreEmptyDir, boolean resolveLink) throws AccessControlException, UnresolvedLinkException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ACCESS CHECK: " + this + ", doCheckOwner=" + doCheckOwner + ", ancestorAccess=" + ancestorAccess + ", parentAccess=" + parentAccess + ", access=" + access + ", subAccess=" + subAccess + ", ignoreEmptyDir=" + ignoreEmptyDir + ", resolveLink=" + resolveLink));
        }
        INodesInPath inodesInPath = dir.getINodesInPath(path, resolveLink);
        int snapshotId = inodesInPath.getPathSnapshotId();
        AuthorizationProvider.INodeAuthorizationInfo[] inodes = inodesInPath.getINodes();
        AuthorizationProvider.get().checkPermission(this.user, this.groups, inodes, snapshotId, doCheckOwner, ancestorAccess, parentAccess, access, subAccess, ignoreEmptyDir);
    }

    public void checkPermission(CachePool pool, FsAction access) throws AccessControlException {
        FsPermission mode = pool.getMode();
        if (this.isSuperUser()) {
            return;
        }
        if (this.user.equals(pool.getOwnerName()) && mode.getUserAction().implies(access)) {
            return;
        }
        if (this.groups.contains(pool.getGroupName()) && mode.getGroupAction().implies(access)) {
            return;
        }
        if (mode.getOtherAction().implies(access)) {
            return;
        }
        throw new AccessControlException("Permission denied while accessing pool " + pool.getPoolName() + ": user " + this.user + " does not have " + access.toString() + " permissions.");
    }
}

