/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.resources;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.hdfs.web.resources.StringParam;

public class AclPermissionParam
extends StringParam {
    public static final String NAME = "aclspec";
    public static final String DEFAULT = "";
    private static StringParam.Domain domain = new StringParam.Domain("aclspec", Pattern.compile("^(default:)?(user|group|mask|other):[[A-Za-z_][A-Za-z0-9._-]]*:([rwx-]{3})?(,(default:)?(user|group|mask|other):[[A-Za-z_][A-Za-z0-9._-]]*:([rwx-]{3})?)*$"));

    public AclPermissionParam(String str) {
        super(domain, str == null || str.equals(DEFAULT) ? null : str);
    }

    public AclPermissionParam(List<AclEntry> acl) {
        super(domain, AclPermissionParam.parseAclSpec(acl).equals(DEFAULT) ? null : AclPermissionParam.parseAclSpec(acl));
    }

    @VisibleForTesting
    public static StringParam.Domain getAclPermissionPattern() {
        return domain;
    }

    @VisibleForTesting
    public static void setAclPermissionPattern(StringParam.Domain dm) {
        domain = dm;
    }

    public static void setAclPermissionPattern(String pattern) {
        domain = new StringParam.Domain(NAME, Pattern.compile(pattern));
    }

    @Override
    public String getName() {
        return NAME;
    }

    public List<AclEntry> getAclPermission(boolean includePermission) {
        String v = (String)this.getValue();
        return v != null ? AclEntry.parseAclSpec((String)v, (boolean)includePermission) : AclEntry.parseAclSpec((String)DEFAULT, (boolean)includePermission);
    }

    private static String parseAclSpec(List<AclEntry> aclEntry) {
        return StringUtils.join(aclEntry, (String)",");
    }
}

