/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.xmlns.writer;

import java.util.HashMap;
import java.util.Iterator;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;

public class DefaultTagDescription
implements TagDescription,
Cloneable {
    private HashMap<String, Boolean> defaultDefinitions = new HashMap();
    private HashMap<TagDefinitionKey, Boolean> tagData = new HashMap();
    private String defaultNamespace;
    private TagDefinitionKey lookupKey = new TagDefinitionKey(null, null);

    public DefaultTagDescription() {
    }

    public DefaultTagDescription(Configuration conf, String prefix) {
        this();
        this.configure(conf, prefix);
    }

    public void configure(Configuration conf, String prefix) {
        if (conf == null) {
            throw new NullPointerException();
        }
        if (prefix == null) {
            throw new NullPointerException();
        }
        HashMap<String, String> knownNamespaces = new HashMap<String, String>();
        String nsConfPrefix = prefix + "namespace.";
        Iterator namespaces = conf.findPropertyKeys(nsConfPrefix);
        while (namespaces.hasNext()) {
            String key = (String)namespaces.next();
            String nsPrefix = key.substring(nsConfPrefix.length());
            String nsUri = conf.getConfigProperty(key);
            knownNamespaces.put(nsPrefix, nsUri);
        }
        this.setDefaultNamespace((String)knownNamespaces.get(conf.getConfigProperty(prefix + "namespace")));
        String globalDefaultKey = prefix + "default";
        boolean globalValue = !"allow".equals(conf.getConfigProperty(globalDefaultKey));
        this.setNamespaceHasCData(null, globalValue);
        String nsDefaultPrefix = prefix + "default.";
        Iterator defaults = conf.findPropertyKeys(nsDefaultPrefix);
        while (defaults.hasNext()) {
            String key = (String)defaults.next();
            String nsPrefix = key.substring(nsDefaultPrefix.length());
            String nsUri = (String)knownNamespaces.get(nsPrefix);
            if (nsUri == null) continue;
            boolean value = !"allow".equals(conf.getConfigProperty(key));
            this.setNamespaceHasCData(nsUri, value);
        }
        String nsTagsPrefix = prefix + "tag.";
        Iterator tags = conf.findPropertyKeys(nsTagsPrefix);
        while (tags.hasNext()) {
            String key = (String)tags.next();
            String tagDef = key.substring(nsTagsPrefix.length());
            boolean value = !"allow".equals(conf.getConfigProperty(key));
            int delim = tagDef.indexOf(46);
            if (delim == -1) {
                this.setElementHasCData(tagDef, value);
                continue;
            }
            String nsPrefix = tagDef.substring(0, delim);
            String nsUri = (String)knownNamespaces.get(nsPrefix);
            if (nsUri == null) continue;
            String tagName = tagDef.substring(delim + 1);
            this.setElementHasCData(nsUri, tagName, value);
        }
    }

    public void setNamespaceHasCData(String namespaceUri, boolean hasCData) {
        this.defaultDefinitions.put(namespaceUri, hasCData ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setElementHasCData(String namespaceUri, String tagName, boolean hasCData) {
        if (namespaceUri == null) {
            throw new NullPointerException();
        }
        if (tagName == null) {
            throw new NullPointerException();
        }
        this.tagData.put(new TagDefinitionKey(namespaceUri, tagName), hasCData ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setElementHasCData(String tagName, boolean hasCData) {
        if (tagName == null) {
            throw new NullPointerException();
        }
        this.tagData.put(new TagDefinitionKey(this.defaultNamespace, tagName), hasCData ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    @Override
    public boolean hasCData(String namespace, String tagname) {
        if (tagname == null) {
            throw new NullPointerException();
        }
        if (namespace == null) {
            namespace = this.defaultNamespace;
        }
        if (!this.tagData.isEmpty()) {
            this.lookupKey.update(namespace, tagname);
            Boolean tagVal = this.tagData.get(this.lookupKey);
            if (tagVal != null) {
                return !Boolean.FALSE.equals(tagVal);
            }
        }
        if (this.defaultDefinitions.isEmpty()) {
            return true;
        }
        Boolean obj = this.defaultDefinitions.get(namespace);
        if (obj != null) {
            return !Boolean.FALSE.equals(obj);
        }
        Boolean defaultValue = this.defaultDefinitions.get(null);
        return !Boolean.FALSE.equals(defaultValue);
    }

    public DefaultTagDescription clone() {
        try {
            DefaultTagDescription clone = (DefaultTagDescription)super.clone();
            clone.tagData = (HashMap)this.tagData.clone();
            clone.defaultDefinitions = (HashMap)this.defaultDefinitions.clone();
            clone.lookupKey = new TagDefinitionKey(null, null);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    private static class TagDefinitionKey {
        private String namespace;
        private String tagName;

        private TagDefinitionKey(String namespace, String tagName) {
            this.namespace = namespace;
            this.tagName = tagName;
        }

        public void update(String namespace, String tagName) {
            this.namespace = namespace;
            this.tagName = tagName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TagDefinitionKey that = (TagDefinitionKey)o;
            if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
                return false;
            }
            return !(this.tagName != null ? !this.tagName.equals(that.tagName) : that.tagName != null);
        }

        public int hashCode() {
            int result = this.namespace != null ? this.namespace.hashCode() : 0;
            result = 29 * result + (this.tagName != null ? this.tagName.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "TagDefinitionKey{namespace='" + this.namespace + '\'' + ", tagName='" + this.tagName + '\'' + '}';
        }
    }
}

