/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.hash.Hashing;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class ScannerIdGenerator {
    private final long serverNameHash;
    private final AtomicInteger scannerIdGen = new AtomicInteger(0);

    public ScannerIdGenerator(ServerName serverName) {
        this.serverNameHash = (long)Hashing.murmur3_32().hashString((CharSequence)serverName.toString()).asInt() << 32;
    }

    public long generateNewScannerId() {
        return (long)this.scannerIdGen.incrementAndGet() & 0xFFFFFFFFL | this.serverNameHash;
    }
}

