/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.util.LinkedList;
import java.util.ListIterator;
import mondrian.olap.MondrianProperties;
import mondrian.util.MemoryMonitor;
import org.apache.log4j.Logger;

public abstract class AbstractMemoryMonitor
implements MemoryMonitor,
MemoryMonitor.Test {
    private static final int MAX_PERCENTAGE = 100;
    private final LinkedList<Entry> listeners = new LinkedList();
    private long lowThreshold;

    protected AbstractMemoryMonitor() {
    }

    protected abstract Logger getLogger();

    protected long getLowThreshold() {
        return this.lowThreshold;
    }

    public int getDefaultThresholdPercentage() {
        return MondrianProperties.instance().MemoryMonitorThreshold.get();
    }

    @Override
    public boolean addListener(MemoryMonitor.Listener listener) {
        return this.addListener(listener, this.getDefaultThresholdPercentage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addListener(MemoryMonitor.Listener listener, int percentage) {
        this.getLogger().info((Object)"addListener enter");
        try {
            long newThreshold = this.convertPercentageToThreshold(percentage);
            Entry e = new Entry(listener, newThreshold);
            LinkedList<Entry> linkedList = this.listeners;
            synchronized (linkedList) {
                long prevLowThreshold = this.generateLowThreshold();
                ListIterator<Entry> iter = this.listeners.listIterator();
                while (iter.hasNext()) {
                    Entry ee = (Entry)iter.next();
                    if (newThreshold > ee.threshold) continue;
                    iter.add(e);
                    e = null;
                    break;
                }
                if (e != null) {
                    this.listeners.addLast(e);
                }
                this.lowThreshold = this.generateLowThreshold();
                if (this.lowThreshold < prevLowThreshold) {
                    this.notifyNewLowThreshold(this.lowThreshold);
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.getLogger().info((Object)"addListener exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateListenerThreshold(MemoryMonitor.Listener listener, int percentage) {
        this.getLogger().info((Object)"updateListenerThreshold enter");
        try {
            long newThreshold = this.convertPercentageToThreshold(percentage);
            LinkedList<Entry> linkedList = this.listeners;
            synchronized (linkedList) {
                long prevLowThreshold = this.generateLowThreshold();
                Entry e = null;
                ListIterator<Entry> iter = this.listeners.listIterator();
                while (iter.hasNext()) {
                    e = (Entry)iter.next();
                    if (e.listener == listener) {
                        iter.remove();
                        break;
                    }
                    e = null;
                }
                if (e != null) {
                    e.threshold = newThreshold;
                    iter = this.listeners.listIterator();
                    while (iter.hasNext()) {
                        Entry ee = (Entry)iter.next();
                        if (newThreshold > ee.threshold) continue;
                        iter.add(e);
                        break;
                    }
                    this.lowThreshold = this.generateLowThreshold();
                    if (this.lowThreshold != prevLowThreshold) {
                        this.notifyNewLowThreshold(this.lowThreshold);
                    }
                }
            }
        }
        finally {
            this.getLogger().info((Object)"updateListenerThreshold exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeListener(MemoryMonitor.Listener listener) {
        this.getLogger().info((Object)"removeListener enter");
        try {
            boolean result = false;
            LinkedList<Entry> linkedList = this.listeners;
            synchronized (linkedList) {
                long prevLowThreshold = this.generateLowThreshold();
                ListIterator iter = this.listeners.listIterator();
                while (iter.hasNext()) {
                    Entry ee = (Entry)iter.next();
                    if (listener != ee.listener) continue;
                    iter.remove();
                    result = true;
                    break;
                }
                this.lowThreshold = this.generateLowThreshold();
                if (this.lowThreshold > prevLowThreshold) {
                    this.notifyNewLowThreshold(this.lowThreshold);
                }
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.getLogger().info((Object)"removeListener exit");
        }
    }

    @Override
    public void removeAllListener() {
        this.getLogger().info((Object)"removeAllListener enter");
        try {
            this.listeners.clear();
            this.notifyNewLowThreshold(this.generateLowThreshold());
        }
        finally {
            this.getLogger().info((Object)"removeAllListener exit");
        }
    }

    protected long generateLowThreshold() {
        return this.listeners.isEmpty() ? Long.MAX_VALUE : this.listeners.get((int)0).threshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(long usedMemory, long maxMemory) {
        LinkedList<Entry> linkedList = this.listeners;
        synchronized (linkedList) {
            for (Entry e : this.listeners) {
                if (usedMemory < e.threshold) continue;
                e.listener.memoryUsageNotification(usedMemory, maxMemory);
            }
        }
    }

    protected void notifyNewLowThreshold(long newLowThreshold) {
    }

    protected long convertPercentageToThreshold(int percentage) {
        if (percentage < 0 || percentage > 100) {
            throw new IllegalArgumentException("Percentage not in range: " + percentage);
        }
        long maxMemory = this.getMaxMemory();
        return maxMemory * (long)percentage / 100L;
    }

    protected int convertThresholdToPercentage(long threshold) {
        long maxMemory = this.getMaxMemory();
        return (int)(100L * threshold / maxMemory);
    }

    protected int usagePercentage() {
        return this.convertThresholdToPercentage(this.getUsedMemory());
    }

    @Override
    public void resetFromTest() {
        long lowThreshold = this.generateLowThreshold();
        this.notifyNewLowThreshold(lowThreshold);
    }

    static class Entry {
        final MemoryMonitor.Listener listener;
        long threshold;

        Entry(MemoryMonitor.Listener listener, long threshold) {
            this.listener = listener;
            this.threshold = threshold;
        }

        public boolean equals(Object other) {
            return other instanceof Entry && this.listener == ((Entry)other).listener;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }
    }
}

