/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.cassandrasstableoutput;

import java.io.File;
import java.net.URI;
import java.security.Permission;
import java.util.HashMap;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.cassandrasstableoutput.SSTableOutputMeta;
import org.pentaho.di.trans.steps.cassandrasstableoutput.writer.AbstractSSTableWriter;
import org.pentaho.di.trans.steps.cassandrasstableoutput.writer.SSTableWriterBuilder;

public class SSTableOutput
extends BaseStep
implements StepInterface {
    private static final SecurityManager sm = System.getSecurityManager();
    protected int rowsSeen;
    protected AbstractSSTableWriter writer;
    protected RowMetaInterface inputMetadata;
    private String[] fieldNames;
    private int[] fieldValueIndices;

    public SSTableOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private void initialize(SSTableOutputMeta smi) throws Exception {
        this.first = false;
        this.rowsSeen = 0;
        this.inputMetadata = this.getInputRowMeta();
        String yamlPath = this.environmentSubstitute(smi.getYamlPath());
        String directory = this.environmentSubstitute(smi.getDirectory());
        String keyspace = this.environmentSubstitute(smi.getCassandraKeyspace());
        String table = this.environmentSubstitute(smi.getTableName());
        String keyField = this.environmentSubstitute(smi.getKeyField());
        String bufferSize = this.environmentSubstitute(smi.getBufferSize());
        if (Utils.isEmpty((CharSequence)yamlPath)) {
            throw new Exception(BaseMessages.getString(SSTableOutputMeta.PKG, (String)"SSTableOutput.Error.NoPathToYAML", (String[])new String[0]));
        }
        this.logBasic(BaseMessages.getString(SSTableOutputMeta.PKG, (String)"SSTableOutput.Message.YAMLPath", (String[])new String[]{yamlPath}));
        File outputDir = Utils.isEmpty((CharSequence)directory) ? new File(System.getProperty("java.io.tmpdir")) : new File(new URI(directory));
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            throw new KettleException(BaseMessages.getString(SSTableOutputMeta.PKG, (String)"SSTableOutput.Error.OutputDirDoesntExist", (String[])new String[0]));
        }
        if (Utils.isEmpty((CharSequence)table)) {
            throw new KettleException(BaseMessages.getString(SSTableOutputMeta.PKG, (String)"SSTableOutput.Error.NoTableSpecified", (String[])new String[0]));
        }
        if (Utils.isEmpty((CharSequence)keyField)) {
            throw new KettleException(BaseMessages.getString(SSTableOutputMeta.PKG, (String)"SSTableOutput.Error.NoKeySpecified", (String[])new String[0]));
        }
        this.fieldNames = this.inputMetadata.getFieldNames();
        this.fieldValueIndices = new int[this.fieldNames.length];
        for (int i = 0; i < this.fieldNames.length; ++i) {
            this.fieldValueIndices[i] = this.inputMetadata.indexOfValue(this.fieldNames[i]);
        }
        if (this.writer != null) {
            this.writer.close();
        }
        SSTableWriterBuilder builder = new SSTableWriterBuilder().withConfig(yamlPath).withDirectory(outputDir.getAbsolutePath()).withKeyspace(keyspace).withTable(table).withRowMeta(this.getInputRowMeta()).withPrimaryKey(keyField).withCqlVersion(smi.getUseCQL3() ? 3 : 2);
        try {
            builder.withBufferSize(Integer.parseInt(bufferSize));
        }
        catch (NumberFormatException nfe) {
            this.logBasic(BaseMessages.getString(SSTableOutputMeta.PKG, (String)"SSTableOutput.Message.DefaultBufferSize", (String[])new String[0]));
        }
        this.writer = builder.build();
        try {
            this.disableSystemExit(sm, this.log);
            this.writer.init();
        }
        catch (Exception e) {
            throw new RuntimeException(BaseMessages.getString(SSTableOutputMeta.PKG, (String)"SSTableOutput.Error.InvalidConfig", (String[])new String[0]), e);
        }
        finally {
            if (System.getSecurityManager() != sm) {
                System.setSecurityManager(sm);
            }
        }
    }

    void disableSystemExit(SecurityManager sm, LogChannelInterface log) {
        try {
            System.setSecurityManager(new NoSystemExitDelegatingSecurityManager(sm));
        }
        catch (SecurityException se) {
            log.logError(BaseMessages.getString(SSTableOutputMeta.PKG, (String)"SSTableOutput.Error.JVMExitProtection", (String[])new String[0]), (Throwable)se);
        }
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        if (this.isStopped()) {
            return false;
        }
        Object[] r = this.getRow();
        if (this.first) {
            try {
                this.initialize((SSTableOutputMeta)smi);
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(SSTableOutputMeta.PKG, (String)"SSTableOutput.Error.WriterInitFailed", (String[])new String[0]), (Throwable)e);
            }
        }
        try {
            if (r == null) {
                this.setOutputDone();
                this.closeWriter();
                return false;
            }
            HashMap<String, Object> record = new HashMap<String, Object>();
            for (int i = 0; i < this.fieldNames.length; ++i) {
                Object value = r[this.fieldValueIndices[i]];
                if (value == null || "".equals(value)) continue;
                record.put(this.fieldNames[i], value);
            }
            this.writer.processRow(record);
            this.incrementLinesWritten();
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(SSTableOutputMeta.PKG, (String)"SSTableOutput.Error.FailedToProcessRow", (String[])new String[0]), e);
            this.putError(this.getInputRowMeta(), r, 1L, e.getMessage(), null, "ERR_SSTABLE_OUTPUT_01");
            this.incrementLinesRejected();
        }
        return true;
    }

    public void setStopped(boolean stopped) {
        super.setStopped(stopped);
        if (stopped) {
            this.closeWriter();
        }
    }

    public void closeWriter() {
        if (this.writer != null) {
            try {
                this.writer.close();
                this.writer = null;
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(SSTableOutputMeta.PKG, (String)"SSTableOutput.Error.FailedToCloseWriter", (String[])new String[0]), e);
            }
        }
    }

    private class NoSystemExitDelegatingSecurityManager
    extends SecurityManager {
        private SecurityManager delegate;

        NoSystemExitDelegatingSecurityManager(SecurityManager delegate) {
            this.delegate = delegate;
        }

        @Override
        public void checkPermission(Permission perm) {
            if (this.delegate != null) {
                this.delegate.checkPermission(perm);
            }
        }

        @Override
        public void checkPermission(Permission perm, Object context) {
            if (this.delegate != null) {
                this.delegate.checkPermission(perm, context);
            }
        }

        @Override
        public void checkExit(int status) {
            throw new JVMShutdownAttemptedException();
        }
    }

    private class JVMShutdownAttemptedException
    extends SecurityException {
        private JVMShutdownAttemptedException() {
        }
    }
}

