/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formatting;

import java.text.ChoiceFormat;
import java.util.Locale;
import org.pentaho.reporting.libraries.formatting.FastFormat;

public class FastChoiceFormat
implements FastFormat {
    private Locale locale;
    private String pattern;
    private ChoiceFormat choiceFormat;

    public FastChoiceFormat(String pattern) {
        this(pattern, Locale.getDefault());
    }

    public FastChoiceFormat(String pattern, Locale locale) {
        if (pattern == null) {
            throw new NullPointerException();
        }
        if (locale == null) {
            throw new NullPointerException();
        }
        this.pattern = pattern;
        this.locale = locale;
        this.choiceFormat = new ChoiceFormat(pattern);
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public String getPattern() {
        return this.pattern;
    }

    @Override
    public String format(Object parameters) {
        return this.choiceFormat.format(parameters);
    }

    @Override
    public FastChoiceFormat clone() {
        try {
            FastChoiceFormat format = (FastChoiceFormat)super.clone();
            format.choiceFormat = (ChoiceFormat)this.choiceFormat.clone();
            return format;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }
}

