/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.services.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import org.pentaho.agilebi.modeler.gwt.BogoPojo;
import org.pentaho.agilebi.modeler.gwt.services.IGwtModelerService;
import org.pentaho.agilebi.modeler.gwt.services.IGwtModelerServiceAsync;
import org.pentaho.agilebi.modeler.services.IModelerServiceAsync;
import org.pentaho.metadata.model.Domain;
import org.pentaho.ui.xul.XulServiceCallback;

public class GwtModelerServiceImpl
implements IModelerServiceAsync {
    IGwtModelerServiceAsync delegate;

    @Override
    public void gwtWorkaround(BogoPojo bogo, final XulServiceCallback<BogoPojo> callback) {
        this.getDelegate().gwtWorkaround(bogo, new AsyncCallback<BogoPojo>(){

            public void onFailure(Throwable throwable) {
                callback.error("Error saving models", throwable);
            }

            public void onSuccess(BogoPojo v) {
                callback.success((Object)v);
            }
        });
    }

    private IGwtModelerServiceAsync getDelegate() {
        if (this.delegate == null) {
            this.delegate = (IGwtModelerServiceAsync)GWT.create(IGwtModelerService.class);
            ServiceDefTarget endpoint = (ServiceDefTarget)this.delegate;
            endpoint.setServiceEntryPoint(GwtModelerServiceImpl.getBaseUrl());
        }
        return this.delegate;
    }

    @Override
    public void generateDomain(String connectionName, String tableName, String dbType, String query, String datasourceName, final XulServiceCallback<Domain> callback) {
        this.getDelegate().generateDomain(connectionName, tableName, dbType, query, datasourceName, new AsyncCallback<Domain>(){

            public void onFailure(Throwable throwable) {
                callback.error("Error generating Metadata Domain", throwable);
            }

            public void onSuccess(Domain domain) {
                callback.success((Object)domain);
            }
        });
    }

    private static String getBaseUrl() {
        String moduleUrl = GWT.getModuleBaseURL();
        if (moduleUrl.indexOf("content") > -1) {
            String baseUrl = moduleUrl.substring(0, moduleUrl.indexOf("content"));
            return baseUrl + "gwtrpc/modelerService";
        }
        return moduleUrl + "modelerService";
    }

    @Override
    public void serializeModels(Domain domain, String name, final XulServiceCallback<String> callback) {
        this.getDelegate().serializeModels(domain, name, new AsyncCallback<String>(){

            public void onFailure(Throwable throwable) {
                callback.error("Error saving models", throwable);
            }

            public void onSuccess(String v) {
                callback.success((Object)v);
            }
        });
    }

    @Override
    public void serializeModels(Domain domain, String name, boolean doOlap, final XulServiceCallback<String> callback) {
        this.getDelegate().serializeModels(domain, name, doOlap, new AsyncCallback<String>(){

            public void onFailure(Throwable throwable) {
                callback.error("Error saving models", throwable);
            }

            public void onSuccess(String v) {
                callback.success((Object)v);
            }
        });
    }

    @Override
    public void loadDomain(String id, final XulServiceCallback<Domain> callback) {
        this.getDelegate().loadDomain(id, new AsyncCallback<Domain>(){

            public void onFailure(Throwable throwable) {
                callback.error("Error loading domain", throwable);
            }

            public void onSuccess(Domain domain) {
                callback.success((Object)domain);
            }
        });
    }
}

