/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.marketplace.domain.services;

import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.kar.KarService;
import org.osgi.framework.Bundle;
import org.osgi.service.cm.ConfigurationAdmin;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.marketplace.domain.model.entities.MarketEntryType;
import org.pentaho.marketplace.domain.model.entities.interfaces.IPlugin;
import org.pentaho.marketplace.domain.model.entities.interfaces.IPluginVersion;
import org.pentaho.marketplace.domain.model.entities.serialization.IMarketplaceXmlSerializer;
import org.pentaho.marketplace.domain.model.factories.interfaces.IDomainStatusMessageFactory;
import org.pentaho.marketplace.domain.model.factories.interfaces.IPluginVersionFactory;
import org.pentaho.marketplace.domain.model.factories.interfaces.IVersionDataFactory;
import org.pentaho.marketplace.domain.services.BasePluginService;
import org.pentaho.marketplace.domain.services.helpers.Util;
import org.pentaho.marketplace.domain.services.interfaces.IRemotePluginProvider;
import org.pentaho.platform.api.engine.IApplicationContext;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.ISecurityHelper;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.VersionHelper;
import org.pentaho.platform.util.VersionInfo;
import org.pentaho.telemetry.ITelemetryService;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.xml.sax.InputSource;

public class BaPluginService
extends BasePluginService {
    private static final String CLOSE_METHOD_NAME = "close";
    private static final String PROPERTY_COLLECTION_SEPARATOR = ",";
    private static final String INSTALL_JOB_NAME = "download_and_install_plugin.kjb";
    private static final String UNINSTALL_JOB_NAME = "uninstall_plugin.kjb";
    private static final String CACHE_FOLDER = "system/plugin-cache/";
    private static final String DOWNLOAD_CACHE_FOLDER = "system/plugin-cache/downloads/";
    private static final String BACKUP_CACHE_FOLDER = "system/plugin-cache/backups/";
    private static final String STAGING_CACHE_FOLDER = "system/plugin-cache/staging/";
    private static final String MARKETPLACE_FOLDER = "system/marketplace";
    private static final String SYSTEM_FOLDER = "system/";
    private static final String PLUGIN_XML_FILE = "plugin.xml";
    private IMarketplaceXmlSerializer xmlPluginsSerializer;
    private ISecurityHelper securityHelper;
    private IApplicationContext applicationContext;
    private Collection<String> authorizedRoles = Collections.emptyList();
    private Collection<String> authorizedUsernames = Collections.emptyList();
    private Bundle bundle;
    private String relativeKettleExecutionFolderPath;
    private String absoluteKettleResourcesSourcePath;

    public IMarketplaceXmlSerializer getXmlSerializer() {
        return this.xmlPluginsSerializer;
    }

    protected BaPluginService setXmlSerializer(IMarketplaceXmlSerializer serializer) {
        this.xmlPluginsSerializer = serializer;
        return this;
    }

    public ISecurityHelper getSecurityHelper() {
        return this.securityHelper;
    }

    protected BaPluginService setSecurityHelper(ISecurityHelper securityHelper) {
        this.securityHelper = securityHelper;
        return this;
    }

    @Override
    protected String getServerVersion() {
        if (super.getServerVersion() == null) {
            VersionInfo versionInfo = VersionHelper.getVersionInfo(PentahoSystem.class);
            this.setServerVersion(versionInfo.getVersionNumber());
        }
        return super.getServerVersion();
    }

    public IPluginManager getPluginManager(IPentahoSession session) {
        return (IPluginManager)PentahoSystem.get(IPluginManager.class, (IPentahoSession)session);
    }

    protected IApplicationContext getApplicationContext() {
        if (this.applicationContext == null) {
            return PentahoSystem.getApplicationContext();
        }
        return this.applicationContext;
    }

    protected BaPluginService setApplicationContext(IApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        return this;
    }

    protected IPentahoSession getCurrentSession() {
        return PentahoSessionHolder.getSession();
    }

    protected BaPluginService setCurrentSession(IPentahoSession session) {
        PentahoSessionHolder.setSession((IPentahoSession)session);
        return this;
    }

    public Collection<String> getAuthorizedRoles() {
        return this.authorizedRoles;
    }

    public void setAuthorizedRoles(Collection<String> authorizedRoles) {
        if (authorizedRoles == null) {
            authorizedRoles = Collections.emptyList();
        }
        this.authorizedRoles = authorizedRoles;
    }

    public void setAuthorizedRoles(String authorizedRolesString) {
        this.setAuthorizedRoles(this.parseStringCollection(authorizedRolesString, PROPERTY_COLLECTION_SEPARATOR));
    }

    public Collection<String> getAuthorizedUsernames() {
        return this.authorizedUsernames;
    }

    public void setAuthorizedUsernames(Collection<String> authorizedUsernames) {
        if (authorizedUsernames == null) {
            authorizedUsernames = Collections.emptyList();
        }
        this.authorizedUsernames = authorizedUsernames;
    }

    public void setAuthorizedUsernames(String authorizedUsernamesString) {
        this.setAuthorizedUsernames(this.parseStringCollection(authorizedUsernamesString, PROPERTY_COLLECTION_SEPARATOR));
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public String getRelativeKettleExecutionFolderPath() {
        return this.relativeKettleExecutionFolderPath;
    }

    public void setRelativeKettleExecutionFolderPath(String folderPath) {
        this.relativeKettleExecutionFolderPath = folderPath;
    }

    public Path getAbsoluteKettleExecutionFolderPath() {
        return this.getMarketplaceFolder().resolve(this.getRelativeKettleExecutionFolderPath());
    }

    public String getAbsoluteKettleResourcesSourcePath() {
        return this.absoluteKettleResourcesSourcePath;
    }

    public void setAbsoluteKettleResourcesSourcePath(String path) {
        this.absoluteKettleResourcesSourcePath = path;
    }

    protected Path getMarketplaceFolder() {
        String marketplacePath = this.getApplicationContext().getSolutionPath(MARKETPLACE_FOLDER);
        return Paths.get(marketplacePath, new String[0]).toAbsolutePath();
    }

    private JobMeta getInstallJobMeta() {
        return this.getJobMeta(INSTALL_JOB_NAME);
    }

    private JobMeta getUninstallJobMeta() {
        return this.getJobMeta(UNINSTALL_JOB_NAME);
    }

    private JobMeta getJobMeta(String jobFileName) {
        String jobFilePath = this.getAbsoluteKettleExecutionFolderPath().resolve(jobFileName).toString();
        JobMeta meta = null;
        try {
            meta = new JobMeta(jobFilePath, null);
        }
        catch (KettleXMLException e) {
            this.getLogger().error((Object)("Unable to create job meta from file path " + jobFilePath), (Throwable)e);
        }
        return meta;
    }

    public BaPluginService(IRemotePluginProvider metadataPluginsProvider, IVersionDataFactory versionDataFactory, IPluginVersionFactory pluginVersionFactory, KarService karService, FeaturesService featuresService, ConfigurationAdmin configurationAdmin, ITelemetryService telemetryService, IDomainStatusMessageFactory domainStatusMessageFactory, IMarketplaceXmlSerializer pluginsSerializer, ISecurityHelper securityHelper, Bundle bundle) {
        super(metadataPluginsProvider, versionDataFactory, pluginVersionFactory, karService, featuresService, configurationAdmin, telemetryService, domainStatusMessageFactory);
        this.setXmlSerializer(pluginsSerializer);
        this.setSecurityHelper(securityHelper);
        this.setBundle(bundle);
    }

    public void init() {
        this.copyKettleFilesToExecutionFolder();
    }

    public void destroy() {
        this.deleteKettleFilesFromExecutionFolder();
    }

    @Override
    public Map<String, IPlugin> getPlugins() {
        Map<String, IPlugin> plugins = super.getPlugins();
        CollectionUtils.filter(plugins.entrySet(), (Predicate)new Predicate(){

            public boolean evaluate(Object mapEntry) {
                Map.Entry mapEntryCasted = (Map.Entry)mapEntry;
                return ((IPlugin)mapEntryCasted.getValue()).getType() == MarketEntryType.Platform;
            }
        });
        return plugins;
    }

    @Override
    protected boolean hasMarketplacePermission() {
        Collection<String> authorizedRoles = this.getAuthorizedRoles();
        Collection<String> authorizedUsernames = this.getAuthorizedUsernames();
        if (authorizedRoles.isEmpty() && authorizedUsernames.isEmpty()) {
            return this.getSecurityHelper().isPentahoAdministrator(this.getCurrentSession());
        }
        Authentication authentication = this.getSecurityHelper().getAuthentication(this.getCurrentSession(), true);
        Collection<String> userRoles = this.getRoles(authentication);
        String userName = authentication.getName();
        return authorizedUsernames.contains(userName) || CollectionUtils.containsAny(authorizedRoles, userRoles);
    }

    private Collection<String> getRoles(Authentication authentication) {
        ArrayList<String> roles = new ArrayList<String>();
        for (GrantedAuthority grantedAuthority : authentication.getAuthorities()) {
            roles.add(grantedAuthority.getAuthority());
        }
        return roles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IPluginVersion getInstalledNonOsgiPluginVersion(IPlugin plugin) {
        block16: {
            IPluginVersion iPluginVersion;
            String versionPath = this.getApplicationContext().getSolutionPath(SYSTEM_FOLDER + plugin.getId() + "/version.xml");
            InputStreamReader reader = null;
            try {
                File file = new File(versionPath);
                if (!file.exists()) {
                    IPluginVersion iPluginVersion2 = null;
                    return iPluginVersion2;
                }
                reader = new FileReader(versionPath);
                IPluginVersion version = this.getXmlSerializer().getInstalledVersion(new InputSource(reader));
                version.setIsOsgi(false);
                iPluginVersion = version;
            }
            catch (Exception e) {
                e.printStackTrace();
                break block16;
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception exception) {}
            }
            return iPluginVersion;
        }
        return null;
    }

    private boolean isLegacyPlugin(String pluginId) {
        String pluginConfigPath = this.getApplicationContext().getSolutionPath(SYSTEM_FOLDER + File.separator + pluginId + File.separator + PLUGIN_XML_FILE);
        return new File(pluginConfigPath).isFile();
    }

    @Override
    protected Collection<String> getInstalledNonOsgiPluginIds() {
        String[] dirs;
        HashSet<String> plugins = new HashSet<String>();
        File systemDir = new File(this.getApplicationContext().getSolutionPath(SYSTEM_FOLDER));
        for (String dir : dirs = systemDir.list((FilenameFilter)DirectoryFileFilter.INSTANCE)) {
            if (!this.isLegacyPlugin(dir) || plugins.contains(dir)) continue;
            plugins.add(dir);
        }
        return plugins;
    }

    @Override
    protected void unloadPlugin(IPlugin plugin) {
        String pluginId = plugin.getId();
        IPluginManager pluginManager = this.getPluginManager(this.getCurrentSession());
        ClassLoader cl = pluginManager.getClassLoader(pluginId);
        if (cl != null && cl instanceof URLClassLoader) {
            try {
                URLClassLoader cl1 = (URLClassLoader)cl;
                Util.closeURLClassLoader(cl1);
                Method closeMethod = cl1.getClass().getMethod(CLOSE_METHOD_NAME, new Class[0]);
                closeMethod.invoke((Object)cl1, new Object[0]);
            }
            catch (Throwable e) {
                if (e instanceof NoSuchMethodException) {
                    this.logger.debug((Object)"Probably running in java 6 so close method on URLClassLoader is not available");
                }
                if (e instanceof IOException) {
                    this.logger.error((Object)"Unable to close class loader for plugin. Will try uninstalling plugin anyway", e);
                }
                this.logger.error((Object)"Error while closing class loader", e);
            }
        }
    }

    @Override
    protected boolean executeNonOsgiInstall(IPlugin plugin, IPluginVersion version) {
        try {
            Result result = this.executeInstallPluginJob(plugin.getId(), version.getDownloadUrl(), version.getSamplesDownloadUrl(), version.getVersion());
            if (result == null || result.getNrErrors() > 0L) {
                return false;
            }
        }
        catch (KettleException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    protected boolean executeNonOsgiUninstall(IPlugin plugin) {
        try {
            Result result = this.executeUninstallPluginJob(plugin.getId());
            if (result == null || result.getNrErrors() > 0L) {
                return false;
            }
        }
        catch (KettleException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    private Result executeInstallPluginJob(String pluginId, String downloadUrl, String samplesDownloadUrl, String availableVersion) throws UnknownParamException {
        JobMeta installMeta = this.getInstallJobMeta();
        if (installMeta == null) {
            this.getLogger().error((Object)"Unable to find install job meta.");
            return null;
        }
        Job job = new Job(null, installMeta);
        File file = new File(this.getApplicationContext().getSolutionPath(DOWNLOAD_CACHE_FOLDER));
        file.mkdirs();
        file = new File(this.getApplicationContext().getSolutionPath(BACKUP_CACHE_FOLDER));
        file.mkdirs();
        file = new File(this.getApplicationContext().getSolutionPath(STAGING_CACHE_FOLDER));
        file.mkdirs();
        job.getJobMeta().setParameterValue("downloadUrl", downloadUrl);
        if (samplesDownloadUrl != null) {
            job.getJobMeta().setParameterValue("samplesDownloadUrl", samplesDownloadUrl);
            job.getJobMeta().setParameterValue("samplesDir", "/public/plugin-samples");
            job.getJobMeta().setParameterValue("samplesTargetDestination", this.getApplicationContext().getSolutionPath("plugin-samples/" + pluginId));
            job.getJobMeta().setParameterValue("samplesTargetBackup", this.getApplicationContext().getSolutionPath(BACKUP_CACHE_FOLDER + pluginId + "_samples_" + new Date().getTime()));
            job.getJobMeta().setParameterValue("samplesDownloadDestination", this.getApplicationContext().getSolutionPath(DOWNLOAD_CACHE_FOLDER + pluginId + "-samples-" + availableVersion + "_" + new Date().getTime() + ".zip"));
            job.getJobMeta().setParameterValue("samplesStagingDestination", this.getApplicationContext().getSolutionPath("system/plugin-cache/staging_samples"));
            job.getJobMeta().setParameterValue("samplesStagingDestinationAndDir", this.getApplicationContext().getSolutionPath("system/plugin-cache/staging_samples/" + pluginId));
        }
        job.getJobMeta().setParameterValue("downloadDestination", this.getApplicationContext().getSolutionPath(DOWNLOAD_CACHE_FOLDER + pluginId + "-" + availableVersion + "_" + new Date().getTime() + ".zip"));
        job.getJobMeta().setParameterValue("stagingDestination", this.getApplicationContext().getSolutionPath(STAGING_CACHE_FOLDER));
        job.getJobMeta().setParameterValue("stagingDestinationAndDir", this.getApplicationContext().getSolutionPath(STAGING_CACHE_FOLDER + pluginId));
        job.getJobMeta().setParameterValue("targetDestination", this.getApplicationContext().getSolutionPath(SYSTEM_FOLDER + pluginId));
        job.getJobMeta().setParameterValue("targetBackup", this.getApplicationContext().getSolutionPath(BACKUP_CACHE_FOLDER + pluginId + "_" + new Date().getTime()));
        job.copyParametersFrom((NamedParams)job.getJobMeta());
        job.setLogLevel(LogLevel.DETAILED);
        job.activateParameters();
        job.start();
        job.waitUntilFinished();
        Result result = job.getResult();
        return result;
    }

    private Result executeUninstallPluginJob(String pluginId) throws UnknownParamException {
        JobMeta uninstallJobMeta = this.getUninstallJobMeta();
        if (uninstallJobMeta == null) {
            this.getLogger().error((Object)"Unable to find uninstall job meta.");
            return null;
        }
        Job job = new Job(null, uninstallJobMeta);
        File file = new File(this.getApplicationContext().getSolutionPath(BACKUP_CACHE_FOLDER));
        file.mkdirs();
        String uninstallBackup = this.getApplicationContext().getSolutionPath(BACKUP_CACHE_FOLDER + pluginId + "_" + new Date().getTime());
        job.getJobMeta().setParameterValue("uninstallLocation", this.getApplicationContext().getSolutionPath(SYSTEM_FOLDER + pluginId));
        job.getJobMeta().setParameterValue("uninstallBackup", uninstallBackup);
        job.getJobMeta().setParameterValue("samplesDir", "/public/plugin-samples/" + pluginId);
        job.copyParametersFrom((NamedParams)job.getJobMeta());
        job.activateParameters();
        job.start();
        job.waitUntilFinished();
        Result result = job.getResult();
        return result;
    }

    private void copyKettleFilesToExecutionFolder() {
        Path kettleExecutionFolderPath = this.getAbsoluteKettleExecutionFolderPath();
        File targetKettleFilesFolder = new File(kettleExecutionFolderPath.toUri());
        if (!targetKettleFilesFolder.exists() && !targetKettleFilesFolder.mkdirs()) {
            this.getLogger().error((Object)("Failed to create temporary folder for marketplace kettle transformations at " + targetKettleFilesFolder.toString()));
        }
        String kettleResourcesSourcePath = this.getAbsoluteKettleResourcesSourcePath();
        ArrayList<String> kettleResourcePaths = Collections.list(this.bundle.getEntryPaths(kettleResourcesSourcePath));
        for (String kettleResourcePath : kettleResourcePaths) {
            this.writeResourceToFolder(kettleResourcePath, kettleExecutionFolderPath);
        }
    }

    private void deleteKettleFilesFromExecutionFolder() {
        URI kettleExecutionFolder = this.getAbsoluteKettleExecutionFolderPath().toUri();
        File targetKettleFilesFolder = new File(kettleExecutionFolder);
        if (targetKettleFilesFolder.exists()) {
            try {
                FileUtils.deleteDirectory((File)targetKettleFilesFolder);
            }
            catch (IOException e) {
                this.getLogger().error((Object)("Unable to delete marketplace temporary kettle execution folder: " + targetKettleFilesFolder.toString()), (Throwable)e);
            }
        }
    }

    private void writeResourceToFolder(URL resourceUrl, Path destinationFolder) {
        try {
            InputStream inputStream = resourceUrl.openConnection().getInputStream();
            String fileName = FilenameUtils.getName((String)resourceUrl.toString());
            Path destinationFile = destinationFolder.resolve(fileName);
            Files.copy(inputStream, destinationFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            this.getLogger().error((Object)("Error copying " + resourceUrl.toString() + " to destination folder " + destinationFolder), (Throwable)e);
        }
    }

    private void writeResourceToFolder(String resourceUrl, Path destinationFolder) {
        URL url = this.getBundle().getResource(resourceUrl);
        this.writeResourceToFolder(url, destinationFolder);
    }

    private Collection<String> parseStringCollection(String string, String valueSeparator) {
        String[] splitString = string.split(valueSeparator);
        ArrayList<String> parsedValues = new ArrayList<String>(splitString.length);
        for (String authorizedRole : splitString) {
            if (authorizedRole == null || (authorizedRole = authorizedRole.trim()).isEmpty()) continue;
            parsedValues.add(authorizedRole);
        }
        return parsedValues;
    }
}

