/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPReply;

public class FTPException
extends Exception {
    public static final String cvsId = "@(#)$Id: FTPException.java,v 1.9 2008-11-17 01:46:56 bruceb Exp $";
    private static final long serialVersionUID = 1L;
    private int replyCode = -1;

    public FTPException(String msg) {
        super(msg);
    }

    public FTPException(String msg, String replyCode) {
        super(msg);
        try {
            this.replyCode = Integer.parseInt(replyCode);
        }
        catch (NumberFormatException ex) {
            this.replyCode = -1;
        }
    }

    public FTPException(FTPReply reply) {
        super(reply.getReplyText());
        try {
            this.replyCode = Integer.parseInt(reply.getReplyCode());
        }
        catch (NumberFormatException ex) {
            this.replyCode = -1;
        }
    }

    public int getReplyCode() {
        return this.replyCode;
    }

    public String toString() {
        StringBuffer b = new StringBuffer(this.getClass().getName());
        b.append(": ");
        if (this.replyCode > 0) {
            b.append(this.replyCode).append(" ");
        }
        b.append(this.getMessage());
        return b.toString();
    }
}

