/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.checkdbconnection;

import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.annotations.JobEntry;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceHolderInterface;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@JobEntry(id="CHECK_DB_CONNECTIONS", i18nPackageName="org.pentaho.di.job.entries.checkdbconnection", name="JobEntryCheckDbConnections.Name", description="JobEntryCheckDbConnections.TypeDesc", categoryDescription="i18n:org.pentaho.di.job:JobCategory.Category.Conditions")
public class JobEntryCheckDbConnections
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryCheckDbConnections.class;
    private DatabaseMeta[] connections = null;
    public static final String[] unitTimeDesc = new String[]{BaseMessages.getString(PKG, (String)"JobEntryCheckDbConnections.UnitTimeMilliSecond.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryCheckDbConnections.UnitTimeSecond.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryCheckDbConnections.UnitTimeMinute.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryCheckDbConnections.UnitTimeHour.Label", (String[])new String[0])};
    public static final String[] unitTimeCode = new String[]{"millisecond", "second", "minute", "hour"};
    public static final int UNIT_TIME_MILLI_SECOND = 0;
    public static final int UNIT_TIME_SECOND = 1;
    public static final int UNIT_TIME_MINUTE = 2;
    public static final int UNIT_TIME_HOUR = 3;
    private String[] waitfors = null;
    private int[] waittimes = null;
    private long timeStart;
    private long now;

    public JobEntryCheckDbConnections(String n) {
        super(n, "");
    }

    public JobEntryCheckDbConnections() {
        this("");
    }

    public Object clone() {
        JobEntryCheckDbConnections je = (JobEntryCheckDbConnections)super.clone();
        return je;
    }

    public DatabaseMeta[] getConnections() {
        return this.connections;
    }

    public void setConnections(DatabaseMeta[] connections) {
        this.connections = connections;
    }

    public String[] getWaitfors() {
        return this.waitfors;
    }

    public void setWaitfors(String[] waitfors) {
        this.waitfors = waitfors;
    }

    public int[] getWaittimes() {
        return this.waittimes;
    }

    public void setWaittimes(int[] waittimes) {
        this.waittimes = waittimes;
    }

    public long getTimeStart() {
        return this.timeStart;
    }

    public long getNow() {
        return this.now;
    }

    private static String getWaitTimeCode(int i) {
        if (i < 0 || i >= unitTimeCode.length) {
            return unitTimeCode[0];
        }
        return unitTimeCode[i];
    }

    public static String getWaitTimeDesc(int i) {
        if (i < 0 || i >= unitTimeDesc.length) {
            return unitTimeDesc[0];
        }
        return unitTimeDesc[i];
    }

    public static int getWaitTimeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < unitTimeDesc.length; ++i) {
            if (!unitTimeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return JobEntryCheckDbConnections.getWaitTimeByCode(tt);
    }

    private static int getWaitTimeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < unitTimeCode.length; ++i) {
            if (!unitTimeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public String getXML() {
        StringBuilder retval = new StringBuilder(120);
        retval.append(super.getXML());
        retval.append("      <connections>").append(Const.CR);
        if (this.connections != null) {
            for (int i = 0; i < this.connections.length; ++i) {
                retval.append("        <connection>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"name", this.connections[i] == null ? null : this.connections[i].getName()));
                retval.append("          ").append(XMLHandler.addTagValue((String)"waitfor", (String)this.waitfors[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"waittime", (String)JobEntryCheckDbConnections.getWaitTimeCode(this.waittimes[i])));
                retval.append("        </connection>").append(Const.CR);
            }
        }
        retval.append("      </connections>").append(Const.CR);
        return retval.toString();
    }

    private static int getWaitByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < unitTimeCode.length; ++i) {
            if (!unitTimeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            Node fields = XMLHandler.getSubNode((Node)entrynode, (String)"connections");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"connection");
            this.connections = new DatabaseMeta[nrFields];
            this.waitfors = new String[nrFields];
            this.waittimes = new int[nrFields];
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"connection", (int)i);
                String dbname = XMLHandler.getTagValue((Node)fnode, (String)"name");
                this.connections[i] = DatabaseMeta.findDatabase(databases, (String)dbname);
                this.waitfors[i] = XMLHandler.getTagValue((Node)fnode, (String)"waitfor");
                this.waittimes[i] = JobEntryCheckDbConnections.getWaitByCode(Const.NVL((String)XMLHandler.getTagValue((Node)fnode, (String)"waittime"), (String)""));
            }
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobEntryCheckDbConnections.ERROR_0001_Cannot_Load_Job_Entry_From_Xml_Node", (String[])new String[]{xe.getMessage()}));
        }
    }

    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "id_database");
            this.connections = new DatabaseMeta[argnr];
            this.waitfors = new String[argnr];
            this.waittimes = new int[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.connections[a] = rep.loadDatabaseMetaFromJobEntryAttribute(id_jobentry, "connection", a, "id_database", databases);
                this.waitfors[a] = rep.getJobEntryAttributeString(id_jobentry, a, "waitfor");
                this.waittimes[a] = JobEntryCheckDbConnections.getWaitByCode(Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, a, "waittime"), (String)""));
            }
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryCheckDbConnections.ERROR_0002_Cannot_Load_Job_From_Repository", (String[])new String[]{"" + id_jobentry, dbe.getMessage()}));
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            if (this.connections != null) {
                for (int i = 0; i < this.connections.length; ++i) {
                    rep.saveDatabaseMetaJobEntryAttribute(id_job, this.getObjectId(), i, "connection", "id_database", this.connections[i]);
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "waittime", JobEntryCheckDbConnections.getWaitTimeCode(this.waittimes[i]));
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "waitfor", this.waitfors[i]);
                }
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryCheckDbConnections.ERROR_0003_Cannot_Save_Job_Entry", (String[])new String[]{"" + id_job, dbe.getMessage()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(true);
        int nrerrors = 0;
        int nrsuccess = 0;
        if (this.connections != null) {
            for (int i = 0; i < this.connections.length && !this.parentJob.isStopped(); ++i) {
                Database db = new Database((LoggingObjectInterface)this, this.connections[i]);
                db.shareVariablesWith((VariableSpace)this);
                try {
                    int iMaximumTimeout;
                    db.connect(this.parentJob.getTransactionId(), null);
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryCheckDbConnections.Connected", (String[])new String[]{this.connections[i].getDatabaseName(), this.connections[i].getName()}));
                    }
                    if ((iMaximumTimeout = Const.toInt((String)this.environmentSubstitute(this.waitfors[i]), (int)0)) > 0) {
                        int Multiple = 1;
                        String waitTimeMessage = unitTimeDesc[0];
                        switch (this.waittimes[i]) {
                            case 0: {
                                Multiple = 1;
                                waitTimeMessage = unitTimeDesc[0];
                                break;
                            }
                            case 1: {
                                Multiple = 1000;
                                waitTimeMessage = unitTimeDesc[1];
                                break;
                            }
                            case 2: {
                                Multiple = 60000;
                                waitTimeMessage = unitTimeDesc[2];
                                break;
                            }
                            case 3: {
                                Multiple = 3600000;
                                waitTimeMessage = unitTimeDesc[3];
                                break;
                            }
                            default: {
                                Multiple = 1000;
                                waitTimeMessage = unitTimeDesc[1];
                            }
                        }
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryCheckDbConnections.Wait", (String[])new String[]{"" + iMaximumTimeout, waitTimeMessage}));
                        }
                        this.timeStart = System.currentTimeMillis();
                        boolean continueLoop = true;
                        while (continueLoop && !this.parentJob.isStopped()) {
                            this.now = System.currentTimeMillis();
                            if (this.now >= this.timeStart + (long)(iMaximumTimeout * Multiple)) {
                                if (this.isDetailed()) {
                                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryCheckDbConnections.WaitTimeIsElapsed.Label", (String[])new String[]{this.connections[i].getDatabaseName(), this.connections[i].getName()}));
                                }
                                continueLoop = false;
                                continue;
                            }
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Exception exception) {}
                        }
                    }
                    ++nrsuccess;
                    if (!this.isDetailed()) continue;
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryCheckDbConnections.ConnectionOK", (String[])new String[]{this.connections[i].getDatabaseName(), this.connections[i].getName()}));
                    continue;
                }
                catch (KettleDatabaseException e) {
                    ++nrerrors;
                    this.logError(BaseMessages.getString(PKG, (String)"JobEntryCheckDbConnections.Exception", (String[])new String[]{this.connections[i].getDatabaseName(), this.connections[i].getName(), e.toString()}));
                    continue;
                }
                finally {
                    if (db != null) {
                        try {
                            db.disconnect();
                            db = null;
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        if (nrerrors > 0) {
            result.setNrErrors((long)nrerrors);
            result.setResult(false);
        }
        if (this.isDetailed()) {
            this.logDetailed("=======================================");
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryCheckDbConnections.Log.Info.ConnectionsInError", (String[])new String[]{"" + nrerrors}));
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryCheckDbConnections.Log.Info.ConnectionsInSuccess", (String[])new String[]{"" + nrsuccess}));
            this.logDetailed("=======================================");
        }
        return result;
    }

    public boolean evaluates() {
        return true;
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        return this.connections;
    }

    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List references = super.getResourceDependencies(jobMeta);
        if (this.connections != null) {
            for (int i = 0; i < this.connections.length; ++i) {
                DatabaseMeta connection = this.connections[i];
                ResourceReference reference = new ResourceReference((ResourceHolderInterface)this);
                reference.getEntries().add(new ResourceEntry(connection.getHostname(), ResourceEntry.ResourceType.SERVER));
                reference.getEntries().add(new ResourceEntry(connection.getDatabaseName(), ResourceEntry.ResourceType.DATABASENAME));
                references.add(reference);
            }
        }
        return references;
    }

    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        JobEntryValidatorUtils.andValidator().validate((CheckResultSourceInterface)this, "tablename", remarks, AndValidator.putValidators((JobEntryValidator[])new JobEntryValidator[]{JobEntryValidatorUtils.notBlankValidator()}));
        JobEntryValidatorUtils.andValidator().validate((CheckResultSourceInterface)this, "columnname", remarks, AndValidator.putValidators((JobEntryValidator[])new JobEntryValidator[]{JobEntryValidatorUtils.notBlankValidator()}));
    }
}

