/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.di.purge;

import com.pentaho.di.purge.IPurgeUtilityLayout;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.Transform;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.slf4j.MDC;

public class PurgeUtilityHTMLLayout
extends Layout
implements IPurgeUtilityLayout {
    protected static final int BUF_SIZE = 256;
    protected static final int MAX_CAPACITY = 1024;
    protected static final String fontCss = "font-family: arial,sans-serif; font-size: x-small";
    protected static final String thCss = "background: #336699; color: #FFFFFF; text-align: left";
    static String TRACE_PREFIX = "<br>&nbsp;&nbsp;&nbsp;&nbsp;";
    private Level loggerLogLevel = Level.DEBUG;
    private StringBuffer sbuf = new StringBuffer(256);
    String title = "Log4J Log Messages";

    public PurgeUtilityHTMLLayout(Level loggerLogLevel) {
        this.loggerLogLevel = loggerLogLevel;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getContentType() {
        return "text/html";
    }

    public void activateOptions() {
    }

    @Override
    public String format(LoggingEvent event) {
        String[] s;
        Level logLevel = event.getLevel();
        if (this.sbuf.capacity() > 1024) {
            this.sbuf = new StringBuffer(256);
        } else {
            this.sbuf.setLength(0);
        }
        if (this.showTimeColumn()) {
            SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            Date date = new Date();
            date.setTime(event.timeStamp);
            String time = null;
            try {
                time = df.format(date);
            }
            catch (Exception ex) {
                LogLog.error((String)"Error occured while converting date.", (Throwable)ex);
            }
            this.sbuf.append(Layout.LINE_SEP + "<tr>" + Layout.LINE_SEP);
            this.sbuf.append("<td>");
            this.sbuf.append(Transform.escapeTags((String)time));
            this.sbuf.append("</td>" + Layout.LINE_SEP);
        }
        this.sbuf.append("<td title=\"Purge File/Folder\">");
        this.sbuf.append(Transform.escapeTags((String)MDC.get((String)"currentFile")));
        this.sbuf.append("</td>" + Layout.LINE_SEP);
        if (this.showLevelColumn()) {
            this.sbuf.append("<td title=\"Level\">");
            if (logLevel.equals((Object)Level.DEBUG)) {
                this.sbuf.append("<font color=\"#339933\">");
                this.sbuf.append(Transform.escapeTags((String)String.valueOf(event.getLevel())));
                this.sbuf.append("</font>");
            } else if (logLevel.isGreaterOrEqual((Priority)Level.WARN)) {
                this.sbuf.append("<font color=\"#993300\"><strong>");
                this.sbuf.append(Transform.escapeTags((String)String.valueOf(event.getLevel())));
                this.sbuf.append("</strong></font>");
            } else {
                this.sbuf.append(Transform.escapeTags((String)String.valueOf(event.getLevel())));
            }
            this.sbuf.append("</td>" + Layout.LINE_SEP);
        }
        if (this.showCodeLineColumn()) {
            LocationInfo locInfo = event.getLocationInformation();
            this.sbuf.append("<td>");
            this.sbuf.append(Transform.escapeTags((String)MDC.get((String)"codeLine")));
            this.sbuf.append("</td>" + Layout.LINE_SEP);
        }
        this.sbuf.append("<td title=\"Message\">");
        this.sbuf.append(Transform.escapeTags((String)event.getRenderedMessage()));
        this.sbuf.append("</td>" + Layout.LINE_SEP);
        this.sbuf.append("</tr>" + Layout.LINE_SEP);
        if (event.getNDC() != null) {
            this.sbuf.append("<tr><td bgcolor=\"#EEEEEE\" style=\"font-size : xx-small;\" colspan=\"6\" title=\"Nested Diagnostic Context\">");
            this.sbuf.append("NDC: " + Transform.escapeTags((String)event.getNDC()));
            this.sbuf.append("</td></tr>" + Layout.LINE_SEP);
        }
        if ((s = event.getThrowableStrRep()) != null) {
            this.sbuf.append("<tr><td bgcolor=\"#993300\" style=\"color:White; font-size : xx-small;\" colspan=\"6\">");
            this.appendThrowableAsHTML(s, this.sbuf);
            this.sbuf.append("</td></tr>" + Layout.LINE_SEP);
        }
        return this.sbuf.toString();
    }

    void appendThrowableAsHTML(String[] s, StringBuffer sbuf) {
        if (s != null) {
            int len = s.length;
            if (len == 0) {
                return;
            }
            sbuf.append(Transform.escapeTags((String)s[0]));
            sbuf.append(Layout.LINE_SEP);
            for (int i = 1; i < len; ++i) {
                sbuf.append(TRACE_PREFIX);
                sbuf.append(Transform.escapeTags((String)s[i]));
                sbuf.append(Layout.LINE_SEP);
            }
        }
    }

    @Override
    public String getHeader() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">" + Layout.LINE_SEP);
        sbuf.append("<html>" + Layout.LINE_SEP);
        sbuf.append("<head>" + Layout.LINE_SEP);
        sbuf.append("<title>" + this.title + "</title>" + Layout.LINE_SEP);
        sbuf.append("<style type=\"text/css\">" + Layout.LINE_SEP);
        sbuf.append("<!--" + Layout.LINE_SEP);
        sbuf.append("body, table {font-family: arial,sans-serif; font-size: x-small;}" + Layout.LINE_SEP);
        sbuf.append("th {background: #336699; color: #FFFFFF; text-align: left;}" + Layout.LINE_SEP);
        sbuf.append("-->" + Layout.LINE_SEP);
        sbuf.append("</style>" + Layout.LINE_SEP);
        sbuf.append("</head>" + Layout.LINE_SEP);
        sbuf.append("<body bgcolor=\"#FFFFFF\" topmargin=\"6\" leftmargin=\"6\" style=\"font-family: arial,sans-serif; font-size: x-small\">" + Layout.LINE_SEP);
        sbuf.append("<hr size=\"1\" noshade>" + Layout.LINE_SEP);
        sbuf.append("Log session start time " + new Date() + "<br>" + Layout.LINE_SEP);
        sbuf.append("<br>" + Layout.LINE_SEP);
        sbuf.append("<table cellspacing=\"0\" cellpadding=\"4\" border=\"1\" bordercolor=\"#224466\" width=\"100%\">" + Layout.LINE_SEP);
        sbuf.append("<tr style=\"background: #336699; color: #FFFFFF; text-align: left\">" + Layout.LINE_SEP);
        if (this.showTimeColumn()) {
            sbuf.append("<th>Time</th>" + Layout.LINE_SEP);
        }
        sbuf.append("<th>File/Folder</th>" + Layout.LINE_SEP);
        if (this.showLevelColumn()) {
            sbuf.append("<th>Level</th>" + Layout.LINE_SEP);
        }
        if (this.showCodeLineColumn()) {
            sbuf.append("<th>File:Line</th>" + Layout.LINE_SEP);
        }
        sbuf.append("<th>Message</th>" + Layout.LINE_SEP);
        sbuf.append("</tr>" + Layout.LINE_SEP);
        return sbuf.toString();
    }

    @Override
    public String getFooter() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("</table>" + Layout.LINE_SEP);
        sbuf.append("<br>" + Layout.LINE_SEP);
        sbuf.append("</body></html>");
        return sbuf.toString();
    }

    @Override
    public boolean ignoresThrowable() {
        return false;
    }

    private boolean showCodeLineColumn() {
        return Level.DEBUG.isGreaterOrEqual((Priority)this.loggerLogLevel);
    }

    private boolean showTimeColumn() {
        return Level.DEBUG.isGreaterOrEqual((Priority)this.loggerLogLevel);
    }

    private boolean showLevelColumn() {
        return true;
    }
}

