/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur;

import java.io.Serializable;
import java.util.List;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.repository.pur.AbstractDelegate;
import org.pentaho.di.repository.pur.ITransformer;
import org.pentaho.di.repository.pur.PurRepository;
import org.pentaho.di.repository.pur.SharedObjectAssembler;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.VersionSummary;
import org.pentaho.platform.api.repository2.unified.data.node.DataNode;
import org.pentaho.platform.api.repository2.unified.data.node.DataNodeRef;
import org.pentaho.platform.api.repository2.unified.data.node.NodeRepositoryFileData;

public class ClusterDelegate
extends AbstractDelegate
implements ITransformer,
SharedObjectAssembler<ClusterSchema>,
Serializable {
    private static final long serialVersionUID = -4350522899150054287L;
    private static final String NODE_ROOT = "Slave";
    private static final String PROP_BASE_PORT = "BASE_PORT";
    private static final String PROP_SOCKETS_BUFFER_SIZE = "SOCKETS_BUFFER_SIZE";
    private static final String PROP_SOCKETS_FLUSH_INTERVAL = "SOCKETS_FLUSH_INTERVAL";
    private static final String PROP_SOCKETS_COMPRESSED = "SOCKETS_COMPRESSED";
    private static final String PROP_DYNAMIC = "DYNAMIC";
    private static final String NODE_ATTRIBUTES = "attributes";
    private static final String PROP_NB_SLAVE_SERVERS = "NB_SLAVE_SERVERS";
    private PurRepository repo;

    public ClusterDelegate(PurRepository repo) {
        this.repo = repo;
    }

    @Override
    public RepositoryElementInterface dataNodeToElement(DataNode rootNode) throws KettleException {
        ClusterSchema clusterSchema = new ClusterSchema();
        this.dataNodeToElement(rootNode, (RepositoryElementInterface)clusterSchema);
        return clusterSchema;
    }

    @Override
    public void dataNodeToElement(DataNode rootNode, RepositoryElementInterface element) throws KettleException {
        ClusterSchema clusterSchema = (ClusterSchema)element;
        clusterSchema.setBasePort(this.getString(rootNode, PROP_BASE_PORT));
        clusterSchema.setSocketsBufferSize(this.getString(rootNode, PROP_SOCKETS_BUFFER_SIZE));
        clusterSchema.setSocketsFlushInterval(this.getString(rootNode, PROP_SOCKETS_FLUSH_INTERVAL));
        clusterSchema.setSocketsCompressed(rootNode.getProperty(PROP_SOCKETS_COMPRESSED).getBoolean());
        clusterSchema.setDynamic(rootNode.getProperty(PROP_DYNAMIC).getBoolean());
        DataNode attrNode = rootNode.getNode(NODE_ATTRIBUTES);
        long nrSlaves = attrNode.getProperty(PROP_NB_SLAVE_SERVERS).getLong();
        int i = 0;
        while ((long)i < nrSlaves) {
            if (attrNode.hasProperty(String.valueOf(i))) {
                DataNodeRef slaveNodeRef = attrNode.getProperty(String.valueOf(i)).getRef();
                clusterSchema.getSlaveServers().add(this.findSlaveServer((ObjectId)new StringObjectId(slaveNodeRef.toString())));
            }
            ++i;
        }
    }

    @Override
    public DataNode elementToDataNode(RepositoryElementInterface element) throws KettleException {
        ClusterSchema clusterSchema = (ClusterSchema)element;
        DataNode rootNode = new DataNode(NODE_ROOT);
        rootNode.setProperty(PROP_BASE_PORT, clusterSchema.getBasePort());
        rootNode.setProperty(PROP_SOCKETS_BUFFER_SIZE, clusterSchema.getSocketsBufferSize());
        rootNode.setProperty(PROP_SOCKETS_FLUSH_INTERVAL, clusterSchema.getSocketsFlushInterval());
        rootNode.setProperty(PROP_SOCKETS_COMPRESSED, clusterSchema.isSocketsCompressed());
        rootNode.setProperty(PROP_DYNAMIC, clusterSchema.isDynamic());
        DataNode attrNode = rootNode.addNode(NODE_ATTRIBUTES);
        attrNode.setProperty(PROP_NB_SLAVE_SERVERS, (long)clusterSchema.getSlaveServers().size());
        for (int i = 0; i < clusterSchema.getSlaveServers().size(); ++i) {
            SlaveServer slaveServer = (SlaveServer)clusterSchema.getSlaveServers().get(i);
            DataNodeRef slaveNodeRef = new DataNodeRef((Serializable)((Object)slaveServer.getObjectId().getId()));
            attrNode.setProperty(String.valueOf(i), slaveNodeRef);
        }
        return rootNode;
    }

    private SlaveServer findSlaveServer(ObjectId slaveServerId) {
        try {
            List<SlaveServer> slaveServers = this.repo.getSlaveServers();
            for (SlaveServer slaveServer : slaveServers) {
                if (!slaveServer.getObjectId().equals(slaveServerId)) continue;
                return slaveServer;
            }
        }
        catch (KettleException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected Repository getRepository() {
        return this.repo;
    }

    @Override
    public ClusterSchema assemble(RepositoryFile file, NodeRepositoryFileData data, VersionSummary version) throws KettleException {
        ClusterSchema clusterSchema = (ClusterSchema)this.dataNodeToElement(data.getNode());
        clusterSchema.setName(file.getTitle());
        clusterSchema.setObjectId((ObjectId)new StringObjectId(file.getId().toString()));
        clusterSchema.setObjectRevision(this.repo.createObjectRevision(version));
        clusterSchema.clearChanged();
        return clusterSchema;
    }
}

