/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.BaseLogTable;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogTableInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.imp.ImportRules;
import org.pentaho.di.imp.rule.ImportValidationFeedback;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.IRepositoryExporter;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.repository.pur.PurRepository;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileTree;

public class PurRepositoryExporter
implements IRepositoryExporter,
Serializable {
    private static final long serialVersionUID = -8972308694755905930L;
    private static Class<?> PKG = PurRepositoryExporter.class;
    private static final int DEFAULT_BATCH_SIZE = 50;
    private static final String REPOSITORY_BATCH_SIZE_PROPERTY = "KettleRepositoryExportBatchSize";
    private int batchSize;
    private PurRepository repository;
    private LogChannelInterface log;
    private ImportRules importRules;

    public PurRepositoryExporter(PurRepository repository) {
        this.repository = repository;
        this.importRules = new ImportRules();
        this.log = repository.getLog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void exportAllObjects(ProgressMonitorListener monitor, String xmlFilename, RepositoryDirectoryInterface root, String exportType) throws KettleException {
        block19: {
            OutputStreamWriter writer;
            block18: {
                this.initBatchSize();
                BufferedOutputStream os = null;
                writer = null;
                os = new BufferedOutputStream(KettleVFS.getOutputStream((String)xmlFilename, (boolean)false));
                writer = new OutputStreamWriter((OutputStream)os, "UTF-8");
                if (monitor != null) {
                    monitor.beginTask("Exporting the repository to XML...", 3);
                }
                root = root == null ? this.repository.findDirectory("/") : root;
                String path = root.getPath();
                RepositoryFileTree repoTree = this.repository.loadRepositoryFileTree(path);
                writer.write(XMLHandler.getXMLHeader());
                writer.write("<repository>" + Const.CR + Const.CR);
                if (monitor != null) {
                    monitor.worked(1);
                }
                if (exportType.equals("all") || exportType.equals("trans")) {
                    writer.write("<transformations>" + Const.CR);
                    this.export(monitor, repoTree, writer, new TransformationBatchExporter());
                    writer.write("</transformations>" + Const.CR);
                }
                if (exportType.equals("all") || exportType.equals("jobs")) {
                    writer.write("<jobs>" + Const.CR);
                    this.export(monitor, repoTree, writer, new JobBatchExporter());
                    writer.write("</jobs>" + Const.CR);
                }
                writer.write("</repository>" + Const.CR + Const.CR);
                if (monitor == null) break block18;
                monitor.worked(1);
                monitor.subTask("Saving XML to file [" + xmlFilename + "]");
                monitor.worked(1);
            }
            try {
                if (writer != null) {
                    writer.close();
                }
                break block19;
            }
            catch (Exception e) {
                this.log.logError(BaseMessages.getString(PKG, (String)"PurRepositoryExporter.ERROR_CLOSE_FILE", (String[])new String[]{xmlFilename}), (Throwable)e);
            }
            break block19;
            catch (IOException e) {
                try {
                    this.log.logError(BaseMessages.getString(PKG, (String)"PurRepositoryExporter.ERROR_CREATE_FILE", (String[])new String[]{xmlFilename}), (Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (Exception e2) {
                        this.log.logError(BaseMessages.getString(PKG, (String)"PurRepositoryExporter.ERROR_CLOSE_FILE", (String[])new String[]{xmlFilename}), (Throwable)e2);
                    }
                    throw throwable;
                }
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (Exception e3) {
                    this.log.logError(BaseMessages.getString(PKG, (String)"PurRepositoryExporter.ERROR_CLOSE_FILE", (String[])new String[]{xmlFilename}), (Throwable)e3);
                }
            }
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    private void initBatchSize() {
        this.batchSize = 50;
        String batchProp = Const.getEnvironmentVariable((String)REPOSITORY_BATCH_SIZE_PROPERTY, null);
        boolean err = false;
        if (!Utils.isEmpty((CharSequence)batchProp)) {
            try {
                this.batchSize = Integer.parseInt(batchProp);
                if (this.batchSize < 1) {
                    err = true;
                }
            }
            catch (Exception ex) {
                err = true;
            }
        }
        if (err) {
            this.batchSize = 50;
            this.log.logError(BaseMessages.getString(PKG, (String)"PurRepositoryExporter.ERROR_INVALID_BATCH_SIZE", (Object[])new Object[]{REPOSITORY_BATCH_SIZE_PROPERTY, batchProp, this.batchSize}), new Object[]{err});
        }
        this.log.logDetailed(BaseMessages.getString(PKG, (String)"PurRepositoryExporter.DETAILED_USED_BATCH_SIZE", (Object[])new Object[]{this.batchSize}));
    }

    private boolean toExport(AbstractMeta meta) {
        boolean shouldExport = true;
        List feedback = this.importRules.verifyRules((Object)meta);
        List errors = ImportValidationFeedback.getErrors((List)feedback);
        if (!errors.isEmpty()) {
            shouldExport = false;
            this.log.logError(BaseMessages.getString(PKG, (String)"PurRepositoryExporter.ERROR_EXPORT_ITEM", (String[])new String[]{meta.getName()}));
            for (ImportValidationFeedback error : errors) {
                this.log.logError(BaseMessages.getString(PKG, (String)"PurRepositoryExporter.ERROR_EXPORT_ITEM_RULE", (String[])new String[]{error.toString()}));
            }
        }
        return shouldExport;
    }

    protected void setGlobalVariablesOfLogTablesNull(List<LogTableInterface> logTables) {
        for (LogTableInterface logTable : logTables) {
            if (!(logTable instanceof BaseLogTable)) continue;
            ((BaseLogTable)logTable).setAllGlobalParametersToNull();
        }
    }

    private void export(ProgressMonitorListener monitor, RepositoryFileTree root, OutputStreamWriter writer, RepositoryFileBatchExporter exporter) throws KettleException {
        ArrayList<RepositoryFileTree> subdirectories = new ArrayList<RepositoryFileTree>();
        if (root.getChildren() != null && !root.getChildren().isEmpty()) {
            Iterator repObjIter = root.getChildren().iterator();
            ArrayList<RepositoryFile> files = new ArrayList<RepositoryFile>();
            while ((monitor == null || !monitor.isCanceled()) && repObjIter.hasNext()) {
                RepositoryFileTree repObj = (RepositoryFileTree)repObjIter.next();
                if (repObj.getFile().isFolder()) {
                    subdirectories.add(repObj);
                    continue;
                }
                if (!exporter.canExport(repObj.getFile())) continue;
                files.add(repObj.getFile());
            }
            if (!files.isEmpty()) {
                this.log.logBasic(BaseMessages.getString(PKG, (String)"PurRepositoryExporter.BASIC_EXPORT_FROM", (Object[])new Object[]{files.size(), exporter.getFriendlyTypeName(), root.getFile().getPath()}));
                for (int i = 0; !(monitor != null && monitor.isCanceled() || i >= files.size()); i += this.batchSize) {
                    int start = i;
                    int end = Math.min(i + this.batchSize, files.size());
                    List<RepositoryFile> group = files.subList(start, end);
                    if (monitor != null) {
                        monitor.subTask("Loading " + group.size() + " " + exporter.getFriendlyTypeName() + " from " + root.getFile().getPath());
                    }
                    try {
                        exporter.export(monitor, group, writer);
                        continue;
                    }
                    catch (KettleException ex) {
                        this.log.logError(BaseMessages.getString(PKG, (String)"PurRepositoryExporter.ERROR_EXPORT", (String[])new String[]{exporter.getFriendlyTypeName(), root.getFile().getPath()}), (Throwable)ex);
                    }
                }
            }
            Iterator subdirIter = subdirectories.iterator();
            while ((monitor == null || !monitor.isCanceled()) && subdirIter.hasNext()) {
                this.export(monitor, (RepositoryFileTree)subdirIter.next(), writer, exporter);
            }
        }
    }

    public void setImportRulesToValidate(ImportRules importRules) {
        this.importRules = importRules;
    }

    public ImportRules getImportRules() {
        return this.importRules;
    }

    private class JobBatchExporter
    implements RepositoryFileBatchExporter {
        private JobBatchExporter() {
        }

        @Override
        public String getFriendlyTypeName() {
            return "jobs";
        }

        @Override
        public boolean canExport(RepositoryFile file) throws KettleException {
            PurRepositoryExporter.this.repository;
            return RepositoryObjectType.JOB.equals((Object)PurRepository.getObjectType(file.getName()));
        }

        @Override
        public void export(ProgressMonitorListener monitor, List<RepositoryFile> files, OutputStreamWriter writer) throws KettleException {
            List<JobMeta> jobs = PurRepositoryExporter.this.repository.loadJobs(monitor, PurRepositoryExporter.this.log, files, true);
            Iterator<JobMeta> jobsMeta = jobs.iterator();
            Iterator<RepositoryFile> filesIter = files.iterator();
            while ((monitor == null || !monitor.isCanceled()) && jobsMeta.hasNext()) {
                JobMeta meta = jobsMeta.next();
                PurRepositoryExporter.this.setGlobalVariablesOfLogTablesNull(meta.getLogTables());
                RepositoryFile file = filesIter.next();
                try {
                    if (!PurRepositoryExporter.this.toExport((AbstractMeta)meta)) continue;
                    writer.write(meta.getXML() + Const.CR);
                }
                catch (Exception ex) {
                    PurRepositoryExporter.this.log.logError(BaseMessages.getString((Class)PKG, (String)"PurRepositoryExporter.ERROR_SAVE_JOB", (String[])new String[]{meta.getName(), file.getPath()}), (Throwable)ex);
                }
            }
        }
    }

    private class TransformationBatchExporter
    implements RepositoryFileBatchExporter {
        private TransformationBatchExporter() {
        }

        @Override
        public String getFriendlyTypeName() {
            return "transformations";
        }

        @Override
        public boolean canExport(RepositoryFile file) throws KettleException {
            PurRepositoryExporter.this.repository;
            return RepositoryObjectType.TRANSFORMATION.equals((Object)PurRepository.getObjectType(file.getName()));
        }

        @Override
        public void export(ProgressMonitorListener monitor, List<RepositoryFile> files, OutputStreamWriter writer) throws KettleException {
            List<TransMeta> transformations = PurRepositoryExporter.this.repository.loadTransformations(monitor, PurRepositoryExporter.this.log, files, true);
            Iterator<TransMeta> transMetasIter = transformations.iterator();
            Iterator<RepositoryFile> filesIter = files.iterator();
            while ((monitor == null || !monitor.isCanceled()) && transMetasIter.hasNext()) {
                TransMeta trans = transMetasIter.next();
                PurRepositoryExporter.this.setGlobalVariablesOfLogTablesNull(trans.getLogTables());
                RepositoryFile file = filesIter.next();
                try {
                    if (!PurRepositoryExporter.this.toExport((AbstractMeta)trans)) continue;
                    writer.write(trans.getXML() + Const.CR);
                }
                catch (Exception ex) {
                    PurRepositoryExporter.this.log.logError(BaseMessages.getString((Class)PKG, (String)"PurRepositoryExporter.ERROR_SAVE_TRANSFORMATION", (String[])new String[]{trans.getName(), file.getPath()}), (Throwable)ex);
                }
            }
        }
    }

    private static interface RepositoryFileBatchExporter {
        public String getFriendlyTypeName();

        public boolean canExport(RepositoryFile var1) throws KettleException;

        public void export(ProgressMonitorListener var1, List<RepositoryFile> var2, OutputStreamWriter var3) throws KettleException;
    }
}

