/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.UserInfo;
import org.pentaho.di.repository.pur.model.IEEUser;
import org.pentaho.di.repository.pur.model.IRole;

public class EEUserInfo
extends UserInfo
implements IEEUser,
Serializable {
    private static final long serialVersionUID = -5327929320581502511L;
    private Set<IRole> roles;

    public EEUserInfo() {
        this.roles = new HashSet<IRole>();
    }

    public EEUserInfo(String login, String password, String username, String description, boolean enabled, Set<IRole> roles) {
        super(login, password, username, description, enabled);
        this.roles = roles;
    }

    public EEUserInfo(String login, String password, String username, String description, boolean enabled) {
        super(login, password, username, description, enabled);
        this.roles = new HashSet<IRole>();
    }

    public EEUserInfo(String login) {
        super(login);
        this.roles = new HashSet<IRole>();
    }

    public EEUserInfo(EEUserInfo copyFrom) {
        super((IUser)copyFrom);
        this.roles = copyFrom.roles != null ? new HashSet<IRole>(copyFrom.roles) : null;
    }

    @Override
    public boolean addRole(IRole role) {
        return this.roles.add(role);
    }

    @Override
    public boolean removeRole(IRole role) {
        return this.roles.remove(role);
    }

    @Override
    public void clearRoles() {
        this.roles.clear();
    }

    @Override
    public void setRoles(Set<IRole> roles) {
        this.roles = roles;
    }

    @Override
    public Set<IRole> getRoles() {
        return this.roles;
    }
}

