/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.pur.controller;

import java.io.Serializable;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.pur.PurRepository;
import org.pentaho.di.repository.pur.model.EEJobMeta;
import org.pentaho.di.repository.pur.model.ILockable;
import org.pentaho.di.repository.pur.model.RepositoryLock;
import org.pentaho.di.ui.repository.pur.services.ILockService;
import org.pentaho.di.ui.spoon.ISpoonMenuController;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.ui.xul.components.XulMenuitem;
import org.pentaho.ui.xul.components.XulToolbarbutton;
import org.pentaho.ui.xul.dom.Document;

public class SpoonMenuLockController
implements ISpoonMenuController,
Serializable {
    private static final long serialVersionUID = -1007051375792274091L;

    public String getName() {
        return "spoonMenuLockController";
    }

    public void updateMenu(Document doc) {
        try {
            Spoon spoon = Spoon.getInstance();
            if (spoon != null && spoon.getRepository() != null && spoon.getRepository() instanceof PurRepository) {
                ILockService service = this.getService(spoon.getRepository());
                EngineMetaInterface meta = spoon.getActiveMeta();
                if (meta != null && meta instanceof ILockable) {
                    RepositoryLock repoLock = null;
                    if (service != null && meta.getObjectId() != null) {
                        repoLock = meta instanceof EEJobMeta ? service.getJobLock(meta.getObjectId()) : service.getTransformationLock(meta.getObjectId());
                    }
                    if (repoLock != null && !service.canUnlockFileById(meta.getObjectId())) {
                        ((XulToolbarbutton)doc.getElementById("toolbar-file-save")).setDisabled(true);
                        ((XulMenuitem)doc.getElementById("file-save")).setDisabled(true);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ILockService getService(Repository repository) throws KettleException {
        if (repository.hasService(ILockService.class)) {
            return (ILockService)repository.getService(ILockService.class);
        }
        throw new IllegalStateException();
    }
}

