/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.docbundle;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.docbundle.BundleUtilities;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public final class WriteableDocumentBundleUtils {
    private static final Log logger = LogFactory.getLog(WriteableDocumentBundleUtils.class);

    private WriteableDocumentBundleUtils() {
    }

    public static boolean removeResource(WriteableDocumentBundle documentBundle, ResourceKey resource) throws IOException {
        if (documentBundle == null) {
            throw new IllegalArgumentException();
        }
        if (resource == null) {
            throw new IllegalArgumentException();
        }
        if (documentBundle.isEmbeddedKey(resource)) {
            return documentBundle.removeEntry(resource.getIdentifierAsString());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceKey embedResource(WriteableDocumentBundle documentBundle, ResourceManager sourceManager, ResourceKey source, String pattern, String mimeType, Map factoryParameters) throws IOException, ResourceException {
        if (documentBundle == null) {
            throw new IllegalArgumentException();
        }
        if (sourceManager == null) {
            throw new IllegalArgumentException();
        }
        if (source == null) {
            throw new IllegalArgumentException();
        }
        if (pattern == null) {
            throw new IllegalArgumentException();
        }
        if (mimeType == null) {
            throw new IllegalArgumentException();
        }
        String name = BundleUtilities.getUniqueName(documentBundle, pattern);
        ResourceData resourceData = sourceManager.load(source);
        InputStream in = resourceData.getResourceAsStream(sourceManager);
        try {
            OutputStream out = documentBundle.createEntry(name, mimeType);
            try {
                IOUtils.getInstance().copyStreams(in, out);
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.error((Object)"Error closing input stream", (Throwable)e);
                }
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                logger.error((Object)"Error closing output stream", (Throwable)e);
            }
        }
        return documentBundle.createResourceKey(name, factoryParameters);
    }
}

