/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.webpackage.core.impl.osgi;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWiring;
import org.pentaho.webpackage.core.IPentahoWebPackage;
import org.pentaho.webpackage.core.impl.PentahoWebPackageImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PentahoWebPackageBundleListener
implements BundleListener {
    private static Logger logger = LoggerFactory.getLogger(PentahoWebPackageBundleListener.class);
    final Map<Long, Iterable<ServiceRegistration<IPentahoWebPackage>>> bundleWebPackageServiceRegistrations = new HashMap<Long, Iterable<ServiceRegistration<IPentahoWebPackage>>>();

    public void bundleChanged(BundleEvent bundleEvent) {
        Bundle bundle = bundleEvent.getBundle();
        int bundleEventType = bundleEvent.getType();
        if (bundleEventType == 2) {
            this.registerWebPackageServices(bundle);
        } else if (bundleEventType == 16 || bundleEventType == 64 || bundleEventType == 4) {
            this.unregisterWebPackageServices(bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerWebPackageServices(Bundle bundle) {
        BundleContext bundleContext;
        if (bundle == null) {
            return;
        }
        Stream<IPentahoWebPackage> webPackages = this.createWebPackages(bundle);
        List webpackageServiceRegistrations = webPackages.map(arg_0 -> PentahoWebPackageBundleListener.lambda$registerWebPackageServices$0(bundleContext = bundle.getBundleContext(), arg_0)).collect(Collectors.toList());
        if (!webpackageServiceRegistrations.isEmpty()) {
            Map<Long, Iterable<ServiceRegistration<IPentahoWebPackage>>> map = this.bundleWebPackageServiceRegistrations;
            synchronized (map) {
                this.bundleWebPackageServiceRegistrations.putIfAbsent(bundle.getBundleId(), webpackageServiceRegistrations);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterWebPackageServices(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        Iterable<ServiceRegistration<IPentahoWebPackage>> bundleServiceRegistrations = this.getBundleServiceRegistrations(bundle.getBundleId());
        if (bundleServiceRegistrations != null) {
            bundleServiceRegistrations.forEach(this::unregisterService);
            Map<Long, Iterable<ServiceRegistration<IPentahoWebPackage>>> map = this.bundleWebPackageServiceRegistrations;
            synchronized (map) {
                this.bundleWebPackageServiceRegistrations.remove(bundle.getBundleId());
            }
        }
    }

    Iterable<ServiceRegistration<IPentahoWebPackage>> getBundleServiceRegistrations(long bundleId) {
        return this.bundleWebPackageServiceRegistrations.get(bundleId);
    }

    private void unregisterService(ServiceRegistration registration) {
        try {
            registration.unregister();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    List<BundleCapability> getWebPackageCapabilities(Bundle bundle) {
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (wiring != null) {
            return wiring.getCapabilities("org.pentaho.webpackage");
        }
        return Collections.emptyList();
    }

    IPentahoWebPackage createWebPackage(Bundle bundle, BundleCapability webPackageCapability) {
        String capabilityRoot = this.getRoot(webPackageCapability);
        try {
            URL packageJsonUrl = bundle.getResource(capabilityRoot + "package.json");
            if (packageJsonUrl != null) {
                return new PentahoWebPackageImpl(capabilityRoot, packageJsonUrl);
            }
            logger.warn(bundle.getSymbolicName() + " [" + bundle.getBundleId() + "]: " + capabilityRoot + "package.json not found.");
        }
        catch (RuntimeException ignored) {
            logger.error(bundle.getSymbolicName() + " [" + bundle.getBundleId() + "]: Error parsing " + capabilityRoot + "package.json.");
        }
        return null;
    }

    Stream<IPentahoWebPackage> createWebPackages(Bundle bundle) {
        return this.getWebPackageCapabilities(bundle).stream().map(capability -> this.createWebPackage(bundle, (BundleCapability)capability)).filter(Objects::nonNull);
    }

    String getRoot(BundleCapability capability) {
        String root = capability.getAttributes().getOrDefault("root", "/");
        if (!root.endsWith("/")) {
            root = root + "/";
        } else {
            while (root.endsWith("//")) {
                root = root.substring(0, root.length() - 1);
            }
        }
        return root;
    }

    private static /* synthetic */ ServiceRegistration lambda$registerWebPackageServices$0(BundleContext bundleContext, IPentahoWebPackage webpackage) {
        return bundleContext.registerService(IPentahoWebPackage.class, (Object)webpackage, null);
    }
}

