/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.s3a.s3guard.DirListingMetadata;
import org.apache.hadoop.fs.s3a.s3guard.MetadataStore;
import org.apache.hadoop.fs.s3a.s3guard.PathMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class MetadataStoreListFilesIterator
implements RemoteIterator<FileStatus> {
    public static final Logger LOG = LoggerFactory.getLogger(MetadataStoreListFilesIterator.class);
    private final boolean allowAuthoritative;
    private final MetadataStore metadataStore;
    private final Set<Path> tombstones = new HashSet<Path>();
    private Iterator<FileStatus> leafNodesIterator = null;

    public MetadataStoreListFilesIterator(MetadataStore ms, PathMetadata meta, boolean allowAuthoritative) throws IOException {
        Preconditions.checkNotNull((Object)ms);
        this.metadataStore = ms;
        this.allowAuthoritative = allowAuthoritative;
        this.prefetch(meta);
    }

    private void prefetch(PathMetadata meta) throws IOException {
        LinkedList<PathMetadata> queue = new LinkedList<PathMetadata>();
        ArrayList<FileStatus> leafNodes = new ArrayList<FileStatus>();
        if (meta != null) {
            Path path = meta.getFileStatus().getPath();
            if (path.isRoot()) {
                DirListingMetadata rootListing = this.metadataStore.listChildren(path);
                if (rootListing != null) {
                    this.tombstones.addAll(rootListing.listTombstones());
                    queue.addAll(rootListing.withoutTombstones().getListing());
                }
            } else {
                queue.add(meta);
            }
        }
        while (!queue.isEmpty()) {
            Path path;
            DirListingMetadata children;
            PathMetadata nextMetadata = (PathMetadata)queue.poll();
            FileStatus nextStatus = nextMetadata.getFileStatus();
            if (nextStatus.isFile()) {
                leafNodes.add(nextStatus);
                continue;
            }
            if (!nextStatus.isDirectory() || (children = this.metadataStore.listChildren(path = nextStatus.getPath())) == null) continue;
            this.tombstones.addAll(children.listTombstones());
            Collection<PathMetadata> liveChildren = children.withoutTombstones().getListing();
            if (!liveChildren.isEmpty()) {
                queue.addAll(liveChildren);
                continue;
            }
            if (!this.allowAuthoritative || !children.isAuthoritative()) continue;
            leafNodes.add(nextStatus);
        }
        this.leafNodesIterator = leafNodes.iterator();
    }

    public boolean hasNext() {
        return this.leafNodesIterator.hasNext();
    }

    public FileStatus next() {
        return this.leafNodesIterator.next();
    }

    public Set<Path> listTombstones() {
        return this.tombstones;
    }
}

