/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.estimate;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.estimate.DiscreteEstimatorBayes;
import weka.classifiers.bayes.net.estimate.DiscreteEstimatorFullBayes;
import weka.classifiers.bayes.net.estimate.SimpleEstimator;
import weka.classifiers.bayes.net.search.local.K2;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Statistics;
import weka.core.Utils;
import weka.estimators.Estimator;

public class BMAEstimator
extends SimpleEstimator {
    static final long serialVersionUID = -1846028304233257309L;
    protected boolean m_bUseK2Prior = false;

    @Override
    public String globalInfo() {
        return "BMAEstimator estimates conditional probability tables of a Bayes network using Bayes Model Averaging (BMA).";
    }

    @Override
    public void estimateCPTs(BayesNet bayesNet) throws Exception {
        int iAttribute;
        this.initCPTs(bayesNet);
        Instances instances = bayesNet.m_Instances;
        for (int iAttribute2 = 0; iAttribute2 < instances.numAttributes(); ++iAttribute2) {
            if (bayesNet.getParentSet(iAttribute2).getNrOfParents() <= 1) continue;
            throw new Exception("Cannot handle networks with nodes with more than 1 parent (yet).");
        }
        BayesNet EmptyNet = new BayesNet();
        K2 oSearchAlgorithm = new K2();
        oSearchAlgorithm.setInitAsNaiveBayes(false);
        oSearchAlgorithm.setMaxNrOfParents(0);
        EmptyNet.setSearchAlgorithm(oSearchAlgorithm);
        EmptyNet.buildClassifier(instances);
        BayesNet NBNet = new BayesNet();
        oSearchAlgorithm.setInitAsNaiveBayes(true);
        oSearchAlgorithm.setMaxNrOfParents(1);
        NBNet.setSearchAlgorithm(oSearchAlgorithm);
        NBNet.buildClassifier(instances);
        for (iAttribute = 0; iAttribute < instances.numAttributes(); ++iAttribute) {
            int iParent;
            int iAttValue;
            if (iAttribute == instances.classIndex()) continue;
            double w1 = 0.0;
            double w2 = 0.0;
            int nAttValues = instances.attribute(iAttribute).numValues();
            if (this.m_bUseK2Prior) {
                for (iAttValue = 0; iAttValue < nAttValues; ++iAttValue) {
                    w1 += Statistics.lnGamma(1.0 + ((DiscreteEstimatorBayes)EmptyNet.m_Distributions[iAttribute][0]).getCount(iAttValue)) - Statistics.lnGamma(1.0);
                }
                w1 += Statistics.lnGamma(nAttValues) - Statistics.lnGamma(nAttValues + instances.numInstances());
                for (iParent = 0; iParent < bayesNet.getParentSet(iAttribute).getCardinalityOfParents(); ++iParent) {
                    int nTotal = 0;
                    for (int iAttValue2 = 0; iAttValue2 < nAttValues; ++iAttValue2) {
                        double nCount = ((DiscreteEstimatorBayes)NBNet.m_Distributions[iAttribute][iParent]).getCount(iAttValue2);
                        w2 += Statistics.lnGamma(1.0 + nCount) - Statistics.lnGamma(1.0);
                        nTotal = (int)((double)nTotal + nCount);
                    }
                    w2 += Statistics.lnGamma(nAttValues) - Statistics.lnGamma(nAttValues + nTotal);
                }
            } else {
                for (iAttValue = 0; iAttValue < nAttValues; ++iAttValue) {
                    w1 += Statistics.lnGamma(1.0 / (double)nAttValues + ((DiscreteEstimatorBayes)EmptyNet.m_Distributions[iAttribute][0]).getCount(iAttValue)) - Statistics.lnGamma(1.0 / (double)nAttValues);
                }
                w1 += Statistics.lnGamma(1.0) - Statistics.lnGamma(1 + instances.numInstances());
                int nParentValues = bayesNet.getParentSet(iAttribute).getCardinalityOfParents();
                for (int iParent2 = 0; iParent2 < nParentValues; ++iParent2) {
                    int nTotal = 0;
                    for (int iAttValue3 = 0; iAttValue3 < nAttValues; ++iAttValue3) {
                        double nCount = ((DiscreteEstimatorBayes)NBNet.m_Distributions[iAttribute][iParent2]).getCount(iAttValue3);
                        w2 += Statistics.lnGamma(1.0 / (double)(nAttValues * nParentValues) + nCount) - Statistics.lnGamma(1.0 / (double)(nAttValues * nParentValues));
                        nTotal = (int)((double)nTotal + nCount);
                    }
                    w2 += Statistics.lnGamma(1.0) - Statistics.lnGamma(1 + nTotal);
                }
            }
            if (w1 < w2) {
                w2 -= w1;
                w1 = 0.0;
                w1 = 1.0 / (1.0 + Math.exp(w2));
                w2 = Math.exp(w2) / (1.0 + Math.exp(w2));
            } else {
                w1 -= w2;
                w2 = 0.0;
                w2 = 1.0 / (1.0 + Math.exp(w1));
                w1 = Math.exp(w1) / (1.0 + Math.exp(w1));
            }
            for (iParent = 0; iParent < bayesNet.getParentSet(iAttribute).getCardinalityOfParents(); ++iParent) {
                bayesNet.m_Distributions[iAttribute][iParent] = new DiscreteEstimatorFullBayes(instances.attribute(iAttribute).numValues(), w1, w2, (DiscreteEstimatorBayes)EmptyNet.m_Distributions[iAttribute][0], (DiscreteEstimatorBayes)NBNet.m_Distributions[iAttribute][iParent], this.m_fAlpha);
            }
        }
        iAttribute = instances.classIndex();
        bayesNet.m_Distributions[iAttribute][0] = EmptyNet.m_Distributions[iAttribute][0];
    }

    @Override
    public void updateClassifier(BayesNet bayesNet, Instance instance) throws Exception {
        throw new Exception("updateClassifier does not apply to BMA estimator");
    }

    @Override
    public void initCPTs(BayesNet bayesNet) throws Exception {
        int nMaxParentCardinality = 1;
        for (int iAttribute = 0; iAttribute < bayesNet.m_Instances.numAttributes(); ++iAttribute) {
            if (bayesNet.getParentSet(iAttribute).getCardinalityOfParents() <= nMaxParentCardinality) continue;
            nMaxParentCardinality = bayesNet.getParentSet(iAttribute).getCardinalityOfParents();
        }
        bayesNet.m_Distributions = new Estimator[bayesNet.m_Instances.numAttributes()][nMaxParentCardinality];
    }

    public boolean isUseK2Prior() {
        return this.m_bUseK2Prior;
    }

    public void setUseK2Prior(boolean bUseK2Prior) {
        this.m_bUseK2Prior = bUseK2Prior;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(1);
        newVector.addElement(new Option("\tWhether to use K2 prior.\n", "k2", 0, "-k2"));
        newVector.addAll(Collections.list(super.listOptions()));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setUseK2Prior(Utils.getFlag("k2", options));
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        if (this.isUseK2Prior()) {
            options.add("-k2");
        }
        Collections.addAll(options, super.getOptions());
        return options.toArray(new String[0]);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10166 $");
    }
}

