/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.search.ci;

import java.io.FileReader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.ParentSet;
import weka.classifiers.bayes.net.search.ci.CISearchAlgorithm;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class ICSSearchAlgorithm
extends CISearchAlgorithm {
    static final long serialVersionUID = -2510985917284798576L;
    private int m_nMaxCardinality = 2;

    String name(int iAttribute) {
        return this.m_instances.attribute(iAttribute).name();
    }

    int maxn() {
        return this.m_instances.numAttributes();
    }

    public void setMaxCardinality(int nMaxCardinality) {
        this.m_nMaxCardinality = nMaxCardinality;
    }

    public int getMaxCardinality() {
        return this.m_nMaxCardinality;
    }

    @Override
    protected void search(BayesNet bayesNet, Instances instances) throws Exception {
        int iNode;
        this.m_BayesNet = bayesNet;
        this.m_instances = instances;
        boolean[][] edges = new boolean[this.maxn() + 1][];
        boolean[][] arrows = new boolean[this.maxn() + 1][];
        SeparationSet[][] sepsets = new SeparationSet[this.maxn() + 1][];
        for (iNode = 0; iNode < this.maxn() + 1; ++iNode) {
            edges[iNode] = new boolean[this.maxn()];
            arrows[iNode] = new boolean[this.maxn()];
            sepsets[iNode] = new SeparationSet[this.maxn()];
        }
        this.calcDependencyGraph(edges, sepsets);
        this.calcVeeNodes(edges, arrows, sepsets);
        this.calcArcDirections(edges, arrows);
        for (iNode = 0; iNode < this.maxn(); ++iNode) {
            ParentSet oParentSet = this.m_BayesNet.getParentSet(iNode);
            while (oParentSet.getNrOfParents() > 0) {
                oParentSet.deleteLastParent(this.m_instances);
            }
            for (int iParent = 0; iParent < this.maxn(); ++iParent) {
                if (!arrows[iParent][iNode]) continue;
                oParentSet.addParent(iParent, this.m_instances);
            }
        }
    }

    void calcDependencyGraph(boolean[][] edges, SeparationSet[][] sepsets) {
        int iNode1;
        for (iNode1 = 0; iNode1 < this.maxn(); ++iNode1) {
            for (int iNode2 = 0; iNode2 < this.maxn(); ++iNode2) {
                edges[iNode1][iNode2] = true;
            }
        }
        for (iNode1 = 0; iNode1 < this.maxn(); ++iNode1) {
            edges[iNode1][iNode1] = false;
        }
        for (int iCardinality = 0; iCardinality <= this.getMaxCardinality(); ++iCardinality) {
            int iNode2;
            int iNode12;
            for (iNode12 = 0; iNode12 <= this.maxn() - 2; ++iNode12) {
                for (iNode2 = iNode12 + 1; iNode2 < this.maxn(); ++iNode2) {
                    SeparationSet oSepSet;
                    if (!edges[iNode12][iNode2] || (oSepSet = this.existsSepSet(iNode12, iNode2, iCardinality, edges)) == null) continue;
                    edges[iNode12][iNode2] = false;
                    edges[iNode2][iNode12] = false;
                    sepsets[iNode12][iNode2] = oSepSet;
                    sepsets[iNode2][iNode12] = oSepSet;
                    System.err.print("I(" + this.name(iNode12) + ", {");
                    for (int iNode3 = 0; iNode3 < iCardinality; ++iNode3) {
                        System.err.print(this.name(oSepSet.m_set[iNode3]) + " ");
                    }
                    System.err.print("} ," + this.name(iNode2) + ")\n");
                }
            }
            System.err.print(iCardinality + " ");
            for (iNode12 = 0; iNode12 < this.maxn(); ++iNode12) {
                System.err.print(this.name(iNode12) + " ");
            }
            System.err.print('\n');
            for (iNode12 = 0; iNode12 < this.maxn(); ++iNode12) {
                for (iNode2 = 0; iNode2 < this.maxn(); ++iNode2) {
                    if (edges[iNode12][iNode2]) {
                        System.err.print("X ");
                        continue;
                    }
                    System.err.print(". ");
                }
                System.err.print(this.name(iNode12) + " ");
                System.err.print('\n');
            }
        }
    }

    SeparationSet existsSepSet(int iNode1, int iNode2, int nCardinality, boolean[][] edges) {
        int iNode3;
        SeparationSet Z = new SeparationSet();
        Z.m_set[nCardinality] = -1;
        if (nCardinality > 0) {
            Z.m_set[0] = this.next(-1, iNode1, iNode2, edges);
            for (iNode3 = 1; iNode3 < nCardinality; ++iNode3) {
                Z.m_set[iNode3] = this.next(Z.m_set[iNode3 - 1], iNode1, iNode2, edges);
            }
        }
        int iZ = nCardinality > 0 ? this.maxn() - Z.m_set[nCardinality - 1] - 1 : 0;
        block1: while (iZ >= 0) {
            if (this.isConditionalIndependent(iNode2, iNode1, Z.m_set, nCardinality)) {
                return Z;
            }
            if (nCardinality > 0) {
                Z.m_set[nCardinality - 1] = this.next(Z.m_set[nCardinality - 1], iNode1, iNode2, edges);
            }
            iZ = nCardinality - 1;
            while (iZ >= 0 && Z.m_set[iZ] >= this.maxn()) {
                for (iZ = nCardinality - 1; iZ >= 0 && Z.m_set[iZ] >= this.maxn(); --iZ) {
                }
                if (iZ < 0) continue block1;
                Z.m_set[iZ] = this.next(Z.m_set[iZ], iNode1, iNode2, edges);
                for (iNode3 = iZ + 1; iNode3 < nCardinality; ++iNode3) {
                    Z.m_set[iNode3] = this.next(Z.m_set[iNode3 - 1], iNode1, iNode2, edges);
                }
                iZ = nCardinality - 1;
            }
        }
        return null;
    }

    int next(int x, int iNode1, int iNode2, boolean[][] edges) {
        ++x;
        while (!(x >= this.maxn() || edges[iNode1][x] && edges[iNode2][x] && x != iNode2)) {
            ++x;
        }
        return x;
    }

    void calcVeeNodes(boolean[][] edges, boolean[][] arrows, SeparationSet[][] sepsets) {
        int iNode2;
        int iNode1;
        for (iNode1 = 0; iNode1 < this.maxn(); ++iNode1) {
            for (iNode2 = 0; iNode2 < this.maxn(); ++iNode2) {
                arrows[iNode1][iNode2] = false;
            }
        }
        for (iNode1 = 0; iNode1 < this.maxn() - 1; ++iNode1) {
            for (iNode2 = iNode1 + 1; iNode2 < this.maxn(); ++iNode2) {
                if (edges[iNode1][iNode2]) continue;
                for (int iNode3 = 0; iNode3 < this.maxn(); ++iNode3) {
                    if (!((iNode3 != iNode1 && iNode3 != iNode2 && edges[iNode1][iNode3] && edges[iNode2][iNode3]) & !sepsets[iNode1][iNode2].contains(iNode3))) continue;
                    arrows[iNode1][iNode3] = true;
                    arrows[iNode2][iNode3] = true;
                }
            }
        }
    }

    void calcArcDirections(boolean[][] edges, boolean[][] arrows) {
        boolean bFound;
        do {
            int m;
            int k;
            int j;
            int i;
            bFound = false;
            for (i = 0; i < this.maxn(); ++i) {
                for (j = 0; j < this.maxn(); ++j) {
                    if (i == j || !arrows[i][j]) continue;
                    for (k = 0; k < this.maxn(); ++k) {
                        if (i == k || j == k || !edges[j][k] || edges[i][k] || arrows[j][k] || arrows[k][j]) continue;
                        arrows[j][k] = true;
                        bFound = true;
                    }
                }
            }
            for (i = 0; i < this.maxn(); ++i) {
                for (j = 0; j < this.maxn(); ++j) {
                    if (i == j || !arrows[i][j]) continue;
                    for (k = 0; k < this.maxn(); ++k) {
                        if (i == k || j == k || !edges[i][k] || !arrows[j][k] || arrows[i][k] || arrows[k][i]) continue;
                        arrows[i][k] = true;
                        bFound = true;
                    }
                }
            }
            for (i = 0; i < this.maxn(); ++i) {
                for (j = 0; j < this.maxn(); ++j) {
                    if (i == j || !arrows[i][j]) continue;
                    for (k = 0; k < this.maxn(); ++k) {
                        if (k == i || k == j || !arrows[k][j] || edges[k][i]) continue;
                        for (m = 0; m < this.maxn(); ++m) {
                            if (m == i || m == j || m == k || !edges[m][i] || arrows[m][i] || arrows[i][m] || !edges[m][j] || arrows[m][j] || arrows[j][m] || !edges[m][k] || arrows[m][k] || arrows[k][m]) continue;
                            arrows[m][j] = true;
                            bFound = true;
                        }
                    }
                }
            }
            for (i = 0; i < this.maxn(); ++i) {
                for (j = 0; j < this.maxn(); ++j) {
                    if (i == j || !arrows[j][i]) continue;
                    for (k = 0; k < this.maxn(); ++k) {
                        if (k == i || k == j || !edges[k][j] || arrows[k][j] || arrows[j][k] || !edges[k][i] || arrows[k][i] || arrows[i][k]) continue;
                        for (m = 0; m < this.maxn(); ++m) {
                            if (m == i || m == j || m == k || !edges[m][i] || arrows[m][i] || arrows[i][m] || !edges[m][k] || arrows[m][k] || arrows[k][m]) continue;
                            arrows[i][m] = true;
                            arrows[k][m] = true;
                            bFound = true;
                        }
                    }
                }
            }
            if (bFound) continue;
            for (i = 0; !bFound && i < this.maxn(); ++i) {
                for (j = 0; !bFound && j < this.maxn(); ++j) {
                    if (!edges[i][j] || arrows[i][j] || arrows[j][i]) continue;
                    arrows[i][j] = true;
                    bFound = true;
                }
            }
        } while (bFound);
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tWhen determining whether an edge exists a search is performed \n\tfor a set Z that separates the nodes. MaxCardinality determines \n\tthe maximum size of the set Z. This greatly influences the \n\tlength of the search. (default 2)", "cardinality", 1, "-cardinality <num>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption("cardinality", options);
        if (tmpStr.length() != 0) {
            this.setMaxCardinality(Integer.parseInt(tmpStr));
        } else {
            this.setMaxCardinality(2);
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-cardinality");
        result.add("" + this.getMaxCardinality());
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public String maxCardinalityTipText() {
        return "When determining whether an edge exists a search is performed for a set Z that separates the nodes. MaxCardinality determines the maximum size of the set Z. This greatly influences the length of the search. Default value is 2.";
    }

    @Override
    public String globalInfo() {
        return "This Bayes Network learning algorithm uses conditional independence tests to find a skeleton, finds V-nodes and applies a set of rules to find the directions of the remaining arrows.";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10166 $");
    }

    public static void main(String[] argv) {
        try {
            BayesNet b = new BayesNet();
            b.setSearchAlgorithm(new ICSSearchAlgorithm());
            Instances instances = new Instances(new FileReader("C:\\eclipse\\workspace\\weka\\data\\contact-lenses.arff"));
            instances.setClassIndex(instances.numAttributes() - 1);
            b.buildClassifier(instances);
            System.out.println(b.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class SeparationSet
    implements RevisionHandler {
        public int[] m_set;

        public SeparationSet() {
            this.m_set = new int[ICSSearchAlgorithm.this.getMaxCardinality() + 1];
        }

        public boolean contains(int nItem) {
            for (int iItem = 0; iItem < ICSSearchAlgorithm.this.getMaxCardinality() && this.m_set[iItem] != -1; ++iItem) {
                if (this.m_set[iItem] != nItem) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 10166 $");
        }
    }
}

