/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.search.fixed;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.BIFReader;
import weka.classifiers.bayes.net.ParentSet;
import weka.classifiers.bayes.net.search.SearchAlgorithm;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class FromFile
extends SearchAlgorithm {
    static final long serialVersionUID = 7334358169507619525L;
    String m_sBIFFile = "";

    public String globalInfo() {
        return "The FromFile reads the structure of a Bayes net from a file in BIFF format.";
    }

    @Override
    public void buildStructure(BayesNet bayesNet, Instances instances) throws Exception {
        BIFReader bifReader = new BIFReader();
        bifReader.processFile(this.m_sBIFFile);
        for (int iAttribute = 0; iAttribute < instances.numAttributes(); ++iAttribute) {
            int iBIFAttribute = bifReader.getNode(bayesNet.getNodeName(iAttribute));
            ParentSet bifParentSet = bifReader.getParentSet(iBIFAttribute);
            for (int iBIFParent = 0; iBIFParent < bifParentSet.getNrOfParents(); ++iBIFParent) {
                int iParent;
                String sParent = bifReader.getNodeName(bifParentSet.getParent(iBIFParent));
                for (iParent = 0; iParent < instances.numAttributes() && !bayesNet.getNodeName(iParent).equals(sParent); ++iParent) {
                }
                if (iParent >= instances.numAttributes()) {
                    throw new Exception("Could not find attribute " + sParent + " from BIF file in data");
                }
                bayesNet.getParentSet(iAttribute).addParent(iParent, instances);
            }
        }
    }

    public void setBIFFile(String sBIFFile) {
        this.m_sBIFFile = sBIFFile;
    }

    public String getBIFFile() {
        return this.m_sBIFFile;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.addElement(new Option("\tName of file containing network structure in BIF format\n", "B", 1, "-B <BIF File>"));
        newVector.addAll(Collections.list(super.listOptions()));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setBIFFile(Utils.getOption('B', options));
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-B");
        options.add("" + this.getBIFFile());
        Collections.addAll(options, super.getOptions());
        return options.toArray(new String[0]);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10166 $");
    }
}

