/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.search.global;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.ParentSet;
import weka.classifiers.bayes.net.search.global.GlobalScoreSearchAlgorithm;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class HillClimber
extends GlobalScoreSearchAlgorithm {
    static final long serialVersionUID = -3885042888195820149L;
    boolean m_bUseArcReversal = false;

    @Override
    protected void search(BayesNet bayesNet, Instances instances) throws Exception {
        this.m_BayesNet = bayesNet;
        double fScore = this.calcScore(bayesNet);
        Operation oOperation = this.getOptimalOperation(bayesNet, instances);
        while (oOperation != null && oOperation.m_fScore > fScore) {
            this.performOperation(bayesNet, instances, oOperation);
            fScore = oOperation.m_fScore;
            oOperation = this.getOptimalOperation(bayesNet, instances);
        }
    }

    boolean isNotTabu(Operation oOperation) {
        return true;
    }

    Operation getOptimalOperation(BayesNet bayesNet, Instances instances) throws Exception {
        Operation oBestOperation = new Operation();
        oBestOperation = this.findBestArcToAdd(bayesNet, instances, oBestOperation);
        oBestOperation = this.findBestArcToDelete(bayesNet, instances, oBestOperation);
        if (this.getUseArcReversal()) {
            oBestOperation = this.findBestArcToReverse(bayesNet, instances, oBestOperation);
        }
        if (oBestOperation.m_fScore == -1.0E100) {
            return null;
        }
        return oBestOperation;
    }

    void performOperation(BayesNet bayesNet, Instances instances, Operation oOperation) throws Exception {
        switch (oOperation.m_nOperation) {
            case 0: {
                this.applyArcAddition(bayesNet, oOperation.m_nHead, oOperation.m_nTail, instances);
                if (!bayesNet.getDebug()) break;
                System.out.print("Add " + oOperation.m_nHead + " -> " + oOperation.m_nTail);
                break;
            }
            case 1: {
                this.applyArcDeletion(bayesNet, oOperation.m_nHead, oOperation.m_nTail, instances);
                if (!bayesNet.getDebug()) break;
                System.out.print("Del " + oOperation.m_nHead + " -> " + oOperation.m_nTail);
                break;
            }
            case 2: {
                this.applyArcDeletion(bayesNet, oOperation.m_nHead, oOperation.m_nTail, instances);
                this.applyArcAddition(bayesNet, oOperation.m_nTail, oOperation.m_nHead, instances);
                if (!bayesNet.getDebug()) break;
                System.out.print("Rev " + oOperation.m_nHead + " -> " + oOperation.m_nTail);
            }
        }
    }

    void applyArcAddition(BayesNet bayesNet, int iHead, int iTail, Instances instances) {
        ParentSet bestParentSet = bayesNet.getParentSet(iHead);
        bestParentSet.addParent(iTail, instances);
    }

    void applyArcDeletion(BayesNet bayesNet, int iHead, int iTail, Instances instances) {
        ParentSet bestParentSet = bayesNet.getParentSet(iHead);
        bestParentSet.deleteParent(iTail, instances);
    }

    Operation findBestArcToAdd(BayesNet bayesNet, Instances instances, Operation oBestOperation) throws Exception {
        int nNrOfAtts = instances.numAttributes();
        for (int iAttributeHead = 0; iAttributeHead < nNrOfAtts; ++iAttributeHead) {
            if (bayesNet.getParentSet(iAttributeHead).getNrOfParents() >= this.m_nMaxNrOfParents) continue;
            for (int iAttributeTail = 0; iAttributeTail < nNrOfAtts; ++iAttributeTail) {
                if (!this.addArcMakesSense(bayesNet, instances, iAttributeHead, iAttributeTail)) continue;
                Operation oOperation = new Operation(iAttributeTail, iAttributeHead, 0);
                double fScore = this.calcScoreWithExtraParent(oOperation.m_nHead, oOperation.m_nTail);
                if (!(fScore > oBestOperation.m_fScore) || !this.isNotTabu(oOperation)) continue;
                oBestOperation = oOperation;
                oBestOperation.m_fScore = fScore;
            }
        }
        return oBestOperation;
    }

    Operation findBestArcToDelete(BayesNet bayesNet, Instances instances, Operation oBestOperation) throws Exception {
        int nNrOfAtts = instances.numAttributes();
        for (int iNode = 0; iNode < nNrOfAtts; ++iNode) {
            ParentSet parentSet = bayesNet.getParentSet(iNode);
            for (int iParent = 0; iParent < parentSet.getNrOfParents(); ++iParent) {
                Operation oOperation = new Operation(parentSet.getParent(iParent), iNode, 1);
                double fScore = this.calcScoreWithMissingParent(oOperation.m_nHead, oOperation.m_nTail);
                if (!(fScore > oBestOperation.m_fScore) || !this.isNotTabu(oOperation)) continue;
                oBestOperation = oOperation;
                oBestOperation.m_fScore = fScore;
            }
        }
        return oBestOperation;
    }

    Operation findBestArcToReverse(BayesNet bayesNet, Instances instances, Operation oBestOperation) throws Exception {
        int nNrOfAtts = instances.numAttributes();
        for (int iNode = 0; iNode < nNrOfAtts; ++iNode) {
            ParentSet parentSet = bayesNet.getParentSet(iNode);
            for (int iParent = 0; iParent < parentSet.getNrOfParents(); ++iParent) {
                int iTail = parentSet.getParent(iParent);
                if (!this.reverseArcMakesSense(bayesNet, instances, iNode, iTail) || bayesNet.getParentSet(iTail).getNrOfParents() >= this.m_nMaxNrOfParents) continue;
                Operation oOperation = new Operation(parentSet.getParent(iParent), iNode, 2);
                double fScore = this.calcScoreWithReversedParent(oOperation.m_nHead, oOperation.m_nTail);
                if (!(fScore > oBestOperation.m_fScore) || !this.isNotTabu(oOperation)) continue;
                oBestOperation = oOperation;
                oBestOperation.m_fScore = fScore;
            }
        }
        return oBestOperation;
    }

    public void setMaxNrOfParents(int nMaxNrOfParents) {
        this.m_nMaxNrOfParents = nMaxNrOfParents;
    }

    public int getMaxNrOfParents() {
        return this.m_nMaxNrOfParents;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(2);
        newVector.addElement(new Option("\tMaximum number of parents", "P", 1, "-P <nr of parents>"));
        newVector.addElement(new Option("\tUse arc reversal operation.\n\t(default false)", "R", 0, "-R"));
        newVector.addElement(new Option("\tInitial structure is empty (instead of Naive Bayes)", "N", 0, "-N"));
        newVector.addAll(Collections.list(super.listOptions()));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setUseArcReversal(Utils.getFlag('R', options));
        this.setInitAsNaiveBayes(!Utils.getFlag('N', options));
        String sMaxNrOfParents = Utils.getOption('P', options);
        if (sMaxNrOfParents.length() != 0) {
            this.setMaxNrOfParents(Integer.parseInt(sMaxNrOfParents));
        } else {
            this.setMaxNrOfParents(100000);
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        if (this.getUseArcReversal()) {
            options.add("-R");
        }
        if (!this.getInitAsNaiveBayes()) {
            options.add("-N");
        }
        options.add("-P");
        options.add("" + this.m_nMaxNrOfParents);
        Collections.addAll(options, super.getOptions());
        return options.toArray(new String[0]);
    }

    public void setInitAsNaiveBayes(boolean bInitAsNaiveBayes) {
        this.m_bInitAsNaiveBayes = bInitAsNaiveBayes;
    }

    public boolean getInitAsNaiveBayes() {
        return this.m_bInitAsNaiveBayes;
    }

    public boolean getUseArcReversal() {
        return this.m_bUseArcReversal;
    }

    public void setUseArcReversal(boolean bUseArcReversal) {
        this.m_bUseArcReversal = bUseArcReversal;
    }

    @Override
    public String globalInfo() {
        return "This Bayes Network learning algorithm uses a hill climbing algorithm adding, deleting and reversing arcs. The search is not restricted by an order on the variables (unlike K2). The difference with B and B2 is that this hill climber also considers arrows part of the naive Bayes structure for deletion.";
    }

    public String useArcReversalTipText() {
        return "When set to true, the arc reversal operation is used in the search.";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10166 $");
    }

    class Operation
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = -2934970456587374967L;
        static final int OPERATION_ADD = 0;
        static final int OPERATION_DEL = 1;
        static final int OPERATION_REVERSE = 2;
        public int m_nTail;
        public int m_nHead;
        public int m_nOperation;
        public double m_fScore = -1.0E100;

        public Operation() {
        }

        public Operation(int nTail, int nHead, int nOperation) {
            this.m_nHead = nHead;
            this.m_nTail = nTail;
            this.m_nOperation = nOperation;
        }

        public boolean equals(Operation other) {
            if (other == null) {
                return false;
            }
            return this.m_nOperation == other.m_nOperation && this.m_nHead == other.m_nHead && this.m_nTail == other.m_nTail;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 10166 $");
        }
    }
}

