/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import weka.classifiers.UpdateableClassifier;
import weka.classifiers.functions.SGD;
import weka.classifiers.meta.MultiClassClassifier;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.unsupervised.instance.RemoveWithValues;

public class MultiClassClassifierUpdateable
extends MultiClassClassifier
implements OptionHandler,
UpdateableClassifier {
    private static final long serialVersionUID = -1619685269774366430L;

    public MultiClassClassifierUpdateable() {
        this.m_Classifier = new SGD();
    }

    @Override
    public String globalInfo() {
        return "A metaclassifier for handling multi-class datasets with 2-class classifiers. This classifier is also capable of applying error correcting output codes for increased accuracy. The base classifier must be an updateable classifier";
    }

    @Override
    public void buildClassifier(Instances insts) throws Exception {
        if (this.m_Classifier == null) {
            throw new Exception("No base classifier has been set!");
        }
        if (!(this.m_Classifier instanceof UpdateableClassifier)) {
            throw new Exception("Base classifier must be updateable!");
        }
        super.buildClassifier(insts);
    }

    @Override
    public void updateClassifier(Instance instance) throws Exception {
        if (!instance.classIsMissing()) {
            if (this.m_Classifiers.length == 1) {
                ((UpdateableClassifier)((Object)this.m_Classifiers[0])).updateClassifier(instance);
                return;
            }
            for (int i = 0; i < this.m_Classifiers.length; ++i) {
                if (this.m_Classifiers[i] == null) continue;
                this.m_ClassFilters[i].input(instance);
                Instance converted = this.m_ClassFilters[i].output();
                if (converted == null) continue;
                converted.dataset().setClassIndex(this.m_ClassAttribute.index());
                ((UpdateableClassifier)((Object)this.m_Classifiers[i])).updateClassifier(converted);
                if (this.m_Method != 3) continue;
                int n = i;
                this.m_SumOfWeights[n] = this.m_SumOfWeights[n] + converted.weight();
            }
        }
    }

    @Override
    public double[] distributionForInstance(Instance inst) throws Exception {
        if (this.m_Classifiers.length == 1) {
            return this.m_Classifiers[0].distributionForInstance(inst);
        }
        double[] probs = new double[inst.numClasses()];
        if (this.m_Method == 3) {
            double[][] r = new double[inst.numClasses()][inst.numClasses()];
            double[][] n = new double[inst.numClasses()][inst.numClasses()];
            for (int i = 0; i < this.m_ClassFilters.length; ++i) {
                if (this.m_Classifiers[i] == null || !(this.m_SumOfWeights[i] > 0.0)) continue;
                Instance tempInst = (Instance)inst.copy();
                tempInst.setDataset(this.m_TwoClassDataset);
                double[] current = this.m_Classifiers[i].distributionForInstance(tempInst);
                Range range = new Range(((RemoveWithValues)this.m_ClassFilters[i]).getNominalIndices());
                range.setUpper(this.m_ClassAttribute.numValues());
                int[] pair = range.getSelection();
                if (this.m_pairwiseCoupling && inst.numClasses() > 2) {
                    r[pair[0]][pair[1]] = current[0];
                    n[pair[0]][pair[1]] = this.m_SumOfWeights[i];
                    continue;
                }
                if (current[0] > current[1]) {
                    int n2 = pair[0];
                    probs[n2] = probs[n2] + 1.0;
                    continue;
                }
                int n3 = pair[1];
                probs[n3] = probs[n3] + 1.0;
            }
            if (this.m_pairwiseCoupling && inst.numClasses() > 2) {
                try {
                    return MultiClassClassifierUpdateable.pairwiseCoupling(n, r);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (Utils.gr(Utils.sum(probs), 0.0)) {
                Utils.normalize(probs);
            }
            return probs;
        }
        probs = super.distributionForInstance(inst);
        return probs;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 9249 $");
    }

    public static void main(String[] argv) {
        MultiClassClassifierUpdateable.runClassifier(new MultiClassClassifierUpdateable(), argv);
    }
}

