/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.clusterers.SimpleKMeans;
import weka.clusterers.SingleClustererEnhancer;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.AllFilter;
import weka.filters.Filter;
import weka.filters.SupervisedFilter;

public class FilteredClusterer
extends SingleClustererEnhancer {
    private static final long serialVersionUID = 1420005943163412943L;
    protected Filter m_Filter;
    protected Instances m_FilteredInstances;

    public FilteredClusterer() {
        this.m_Clusterer = new SimpleKMeans();
        this.m_Filter = new AllFilter();
    }

    public String globalInfo() {
        return "Class for running an arbitrary clusterer on data that has been passed through an arbitrary filter. Like the clusterer, the structure of the filter is based exclusively on the training data and test instances will be processed by the filter without changing their structure.";
    }

    protected String defaultFilterString() {
        return AllFilter.class.getName();
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tFull class name of filter to use, followed\n\tby filter options.\n\teg: \"weka.filters.unsupervised.attribute.Remove -V -R 1,2\"\n(default: " + this.defaultFilterString() + ")", "F", 1, "-F <filter specification>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('F', options);
        if (tmpStr.length() > 0) {
            String[] tmpOptions = Utils.splitOptions(tmpStr);
            if (tmpOptions.length == 0) {
                throw new IllegalArgumentException("Invalid filter specification string");
            }
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            this.setFilter((Filter)Utils.forName(Filter.class, tmpStr, tmpOptions));
        } else {
            this.setFilter(new AllFilter());
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.addElement("-F");
        result.addElement(this.getFilterSpec());
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public String filterTipText() {
        return "The filter to be used.";
    }

    public void setFilter(Filter filter) {
        this.m_Filter = filter;
        if (this.m_Filter instanceof SupervisedFilter) {
            System.out.println("WARNING: you are using a supervised filter, which will leak information about the class attribute!");
        }
    }

    public Filter getFilter() {
        return this.m_Filter;
    }

    protected String getFilterSpec() {
        Filter filter = this.getFilter();
        String result = filter.getClass().getName();
        if (filter instanceof OptionHandler) {
            result = result + " " + Utils.joinOptions(filter.getOptions());
        }
        return result;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result;
        if (this.getFilter() == null) {
            result = super.getCapabilities();
            result.disableAll();
            result.enable(Capabilities.Capability.NO_CLASS);
        } else {
            result = this.getFilter().getCapabilities();
        }
        for (Capabilities.Capability cap : Capabilities.Capability.values()) {
            result.enableDependency(cap);
        }
        return result;
    }

    @Override
    public void buildClusterer(Instances data) throws Exception {
        if (this.m_Clusterer == null) {
            throw new Exception("No base clusterer has been set!");
        }
        if (data.classIndex() > -1) {
            data = new Instances(data);
            data.deleteWithMissingClass();
        }
        this.m_Filter.setInputFormat(data);
        data = Filter.useFilter(data, this.m_Filter);
        this.getClusterer().getCapabilities().testWithFail(data);
        this.m_FilteredInstances = data.stringFreeStructure();
        this.m_Clusterer.buildClusterer(data);
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_Filter.numPendingOutput() > 0) {
            throw new Exception("Filter output queue not empty!");
        }
        if (!this.m_Filter.input(instance)) {
            throw new Exception("Filter didn't make the test instance immediately available!");
        }
        this.m_Filter.batchFinished();
        Instance newInstance = this.m_Filter.output();
        return this.m_Clusterer.distributionForInstance(newInstance);
    }

    public String toString() {
        String result = this.m_FilteredInstances == null ? "FilteredClusterer: No model built yet." : "FilteredClusterer using " + this.getClustererSpec() + " on data filtered through " + this.getFilterSpec() + "\n\nFiltered Header\n" + this.m_FilteredInstances.toString() + "\n\nClusterer Model\n" + this.m_Clusterer.toString();
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10213 $");
    }

    public static void main(String[] args) {
        FilteredClusterer.runClusterer(new FilteredClusterer(), args);
    }
}

