/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class ClassloaderUtil
implements RevisionHandler {
    private static final Class<?>[] parameters = new Class[]{URL.class};

    public static void addFile(String s) throws IOException {
        File f = new File(s);
        ClassloaderUtil.addFile(f);
    }

    public static void addFile(File f) throws IOException {
        ClassloaderUtil.addURL(f.toURI().toURL());
    }

    public static void addURL(URL u) throws IOException {
        URL[] urls;
        ClassloaderUtil clu = new ClassloaderUtil();
        URLClassLoader sysLoader = (URLClassLoader)clu.getClass().getClassLoader();
        for (URL url : urls = sysLoader.getURLs()) {
            if (!url.toString().toLowerCase().equals(u.toString().toLowerCase())) continue;
            System.err.println("URL " + u + " is already in the CLASSPATH");
            return;
        }
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", parameters);
            method.setAccessible(true);
            method.invoke((Object)sysLoader, u);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader");
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10213 $");
    }
}

