/*
 * Decompiled with CFR 0.152.
 */
package weka.core.matrix;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class FloatingPointFormat
extends DecimalFormat
implements RevisionHandler {
    private static final long serialVersionUID = 4500373755333429499L;
    protected DecimalFormat nf;
    protected int width;
    protected int decimal;
    protected boolean trailing = true;

    public FloatingPointFormat() {
        this(8, 5);
    }

    public FloatingPointFormat(int digits) {
        this(8, 2);
    }

    public FloatingPointFormat(int w, int d) {
        this.width = w;
        this.decimal = d;
        this.nf = new DecimalFormat(FloatingPointFormat.pattern(w, d));
        this.nf.setPositivePrefix(" ");
        this.nf.setNegativePrefix("-");
    }

    public FloatingPointFormat(int w, int d, boolean trailingZeros) {
        this(w, d);
        this.trailing = trailingZeros;
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        int i;
        StringBuffer s = new StringBuffer(this.nf.format(number));
        if (s.length() > this.width) {
            if (s.charAt(0) == ' ' && s.length() == this.width + 1) {
                s.deleteCharAt(0);
            } else {
                s.setLength(this.width);
                for (i = 0; i < this.width; ++i) {
                    s.setCharAt(i, '*');
                }
            }
        } else {
            for (i = 0; i < this.width - s.length(); ++i) {
                s.insert(0, ' ');
            }
        }
        if (!this.trailing && this.decimal > 0) {
            while (s.charAt(s.length() - 1) == '0') {
                s.deleteCharAt(s.length() - 1);
            }
            if (s.charAt(s.length() - 1) == '.') {
                s.deleteCharAt(s.length() - 1);
            }
        }
        return toAppendTo.append(s);
    }

    public static String pattern(int w, int d) {
        StringBuffer s = new StringBuffer();
        s.append(FloatingPointFormat.padding(w - d - 3, '#'));
        if (d == 0) {
            s.append('0');
        } else {
            s.append("0.");
            s.append(FloatingPointFormat.padding(d, '0'));
        }
        return s.toString();
    }

    private static StringBuffer padding(int n, char c) {
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            text.append(c);
        }
        return text;
    }

    public int width() {
        if (!this.trailing) {
            throw new RuntimeException("flexible width");
        }
        return this.width;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8048 $");
    }
}

