/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.clusterers.EM;
import weka.core.Attribute;
import weka.core.ContingencyTables;
import weka.core.DenseInstance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Statistics;
import weka.core.Utils;
import weka.estimators.UnivariateDensityEstimator;
import weka.estimators.UnivariateIntervalEstimator;
import weka.estimators.UnivariateQuantileEstimator;

public class UnivariateMixtureEstimator
implements UnivariateDensityEstimator,
UnivariateIntervalEstimator,
UnivariateQuantileEstimator,
OptionHandler,
Serializable {
    private static final long serialVersionUID = -2035274930137353656L;
    protected Instances m_Instances;
    protected EM m_MixtureModel;
    protected int m_NumComponents = -1;
    protected int m_MaxNumComponents = 5;
    protected int m_Seed = 1;
    protected int m_NumBootstrapRuns = 10;
    protected double m_Width = Double.MAX_VALUE;
    protected double m_Exponent = -0.25;
    protected double m_MinWidth = 1.0E-6;
    protected int m_NumIntervals = 1000;
    protected double m_Min = Double.MAX_VALUE;
    protected double m_Max = -1.7976931348623157E308;
    protected double m_WeightedSum = 0.0;
    protected double m_WeightedSumSquared = 0.0;
    protected double m_SumOfWeights = 0.0;
    protected boolean m_UseNormalizedEntropy = false;
    protected boolean m_Debug = false;

    public String globalInfo() {
        return "Estimates a univariate mixture model.";
    }

    public boolean getUseNormalizedEntropy() {
        return this.m_UseNormalizedEntropy;
    }

    public void setUseNormalizedEntropy(boolean useNormalizedEntropy) {
        this.m_UseNormalizedEntropy = useNormalizedEntropy;
    }

    public String numBootstrapRunsToolTipText() {
        return "The number of Bootstrap runs to choose the number of components.";
    }

    public int getNumBootstrapRuns() {
        return this.m_NumBootstrapRuns;
    }

    public void setNumBootstrapRuns(int numBootstrapRuns) {
        this.m_NumBootstrapRuns = numBootstrapRuns;
    }

    public String numComponentsToolTipText() {
        return "The number of mixture components to use.";
    }

    public int getNumComponents() {
        return this.m_NumComponents;
    }

    public void setNumComponents(int numComponents) {
        this.m_NumComponents = numComponents;
    }

    public String seedTipText() {
        return "The random number seed to be used.";
    }

    public void setSeed(int seed) {
        this.m_Seed = seed;
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public String maxNumComponentsToolTipText() {
        return "The maximum number of mixture components to use.";
    }

    public int getMaxNumComponents() {
        return this.m_MaxNumComponents;
    }

    public void setMaxNumComponents(int maxNumComponents) {
        this.m_MaxNumComponents = maxNumComponents;
    }

    public UnivariateMixtureEstimator() {
        ArrayList<Attribute> att = new ArrayList<Attribute>(1);
        att.add(new Attribute("x"));
        this.m_Instances = new Instances("Mixture estimator data", att, 100);
    }

    @Override
    public void addValue(double value, double weight) {
        this.m_MixtureModel = null;
        this.m_Instances.add(new DenseInstance(weight, new double[]{value}));
        this.m_WeightedSum += value * weight;
        this.m_WeightedSumSquared += value * value * weight;
        this.m_SumOfWeights += weight;
        if (value < this.m_Min) {
            this.m_Min = value;
        }
        if (value > this.m_Max) {
            this.m_Max = value;
        }
    }

    protected int findNumComponentsUsingBootStrap() {
        if (this.m_NumComponents > 0) {
            return this.m_NumComponents;
        }
        if (this.m_MaxNumComponents <= 1) {
            return 1;
        }
        Random random = new Random(this.m_Seed);
        double bestLogLikelihood = -1.7976931348623157E308;
        int bestNumComponents = 1;
        for (int i = 1; i <= this.m_MaxNumComponents; ++i) {
            double logLikelihood = 0.0;
            for (int k = 0; k <= this.m_NumBootstrapRuns; ++k) {
                double locLogLikelihood = 0.0;
                boolean[] inBag = new boolean[this.m_Instances.numInstances()];
                EM mixtureModel = this.buildModel(this.m_Seed, i, this.m_Instances.resampleWithWeights(random, inBag, true));
                try {
                    double totalWeight = 0.0;
                    for (int j = 0; j < this.m_Instances.numInstances(); ++j) {
                        if (inBag[j]) continue;
                        double weight = this.m_Instances.instance(j).weight();
                        locLogLikelihood += weight * mixtureModel.logDensityForInstance(this.m_Instances.instance(j));
                        totalWeight += weight;
                    }
                    locLogLikelihood /= totalWeight;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    locLogLikelihood = -1.7976931348623157E308;
                }
                logLikelihood += locLogLikelihood;
            }
            logLikelihood /= (double)this.m_NumBootstrapRuns;
            if (this.m_Debug) {
                System.err.println("Loglikelihood: " + logLikelihood + "\tNumber of components: " + i);
            }
            if (!(logLikelihood > bestLogLikelihood)) continue;
            bestNumComponents = i;
            bestLogLikelihood = logLikelihood;
        }
        return bestNumComponents;
    }

    protected double loglikelihood(EM model, Instances data) {
        double logLikelihood = 0.0;
        try {
            for (int j = 0; j < data.numInstances(); ++j) {
                logLikelihood += data.instance(j).weight() * model.logDensityForInstance(data.instance(j));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logLikelihood = -1.7976931348623157E308;
        }
        return logLikelihood;
    }

    protected double entropy(EM model, Instances data) {
        double entropy = 0.0;
        try {
            for (int j = 0; j < data.numInstances(); ++j) {
                entropy += data.instance(j).weight() * ContingencyTables.entropy(model.distributionForInstance(data.instance(j)));
            }
            entropy *= Utils.log2;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            entropy = Double.MAX_VALUE;
        }
        return entropy;
    }

    protected EM findModelUsingNormalizedEntroy() {
        if (this.m_NumComponents > 0) {
            return this.buildModel(this.m_Seed, this.m_NumComponents, this.m_Instances);
        }
        if (this.m_MaxNumComponents <= 1) {
            return this.buildModel(this.m_Seed, 1, this.m_Instances);
        }
        EM bestMixtureModel = this.buildModel(this.m_Seed, 1, this.m_Instances);
        double loglikelihoodForOneCluster = this.loglikelihood(bestMixtureModel, this.m_Instances);
        double bestNormalizedEntropy = 1.0;
        for (int i = 2; i <= this.m_MaxNumComponents; ++i) {
            EM mixtureModel = this.buildModel(this.m_Seed, i, this.m_Instances);
            double loglikelihood = this.loglikelihood(mixtureModel, this.m_Instances);
            if (loglikelihood < loglikelihoodForOneCluster) continue;
            double entropy = this.entropy(mixtureModel, this.m_Instances);
            double normalizedEntropy = entropy / (loglikelihood - loglikelihoodForOneCluster);
            if (this.m_Debug) {
                System.err.println("Entropy: " + entropy + "\tLogLikelihood: " + loglikelihood + "\tLoglikelihood for one cluster: " + loglikelihoodForOneCluster + "\tNormalized entropy: " + normalizedEntropy + "\tNumber of components: " + i);
            }
            if (!(normalizedEntropy < bestNormalizedEntropy)) continue;
            bestMixtureModel = mixtureModel;
            bestNormalizedEntropy = normalizedEntropy;
        }
        return bestMixtureModel;
    }

    protected EM buildModel(int seed, int numComponents, Instances data) {
        try {
            EM mixtureModel = new EM();
            mixtureModel.setSeed(seed);
            mixtureModel.setNumClusters(numComponents);
            mixtureModel.buildClusterer(data);
            return mixtureModel;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void updateModel() {
        if (this.m_MixtureModel != null) {
            return;
        }
        if (this.m_Instances.numInstances() > 0) {
            this.m_MixtureModel = this.m_UseNormalizedEntropy ? this.findModelUsingNormalizedEntroy() : this.buildModel(this.m_Seed, this.findNumComponentsUsingBootStrap(), this.m_Instances);
            double mean = this.m_WeightedSum / this.m_SumOfWeights;
            double variance = this.m_WeightedSumSquared / this.m_SumOfWeights - mean * mean;
            if (variance < 0.0) {
                variance = 0.0;
            }
            this.m_Width = Math.sqrt(variance) * Math.pow(this.m_SumOfWeights, this.m_Exponent);
            if (this.m_Width <= this.m_MinWidth) {
                this.m_Width = this.m_MinWidth;
            }
        }
    }

    @Override
    public double[][] predictIntervals(double conf) {
        this.updateModel();
        double val = Statistics.normalInverse(1.0 - (1.0 - conf) / 2.0);
        double min = this.m_Min - val * this.m_Width;
        double max = this.m_Max + val * this.m_Width;
        double delta = (max - min) / (double)this.m_NumIntervals;
        double[] probabilities = new double[this.m_NumIntervals];
        double leftVal = Math.exp(this.logDensity(min));
        for (int i = 0; i < this.m_NumIntervals; ++i) {
            double rightVal = Math.exp(this.logDensity(min + (double)(i + 1) * delta));
            probabilities[i] = 0.5 * (leftVal + rightVal) * delta;
            leftVal = rightVal;
        }
        int[] sortedIndices = Utils.sort(probabilities);
        double sum = 0.0;
        boolean[] toUse = new boolean[probabilities.length];
        for (int k = 0; sum < conf && k < toUse.length; sum += probabilities[sortedIndices[toUse.length - (k + 1)]], ++k) {
            toUse[sortedIndices[toUse.length - (k + 1)]] = true;
        }
        probabilities = null;
        ArrayList<double[]> intervals = new ArrayList<double[]>();
        double[] interval = null;
        boolean haveStartedInterval = false;
        for (int i = 0; i < this.m_NumIntervals; ++i) {
            if (toUse[i]) {
                if (!haveStartedInterval) {
                    haveStartedInterval = true;
                    interval = new double[]{min + (double)i * delta, min + (double)(i + 1) * delta};
                }
                continue;
            }
            if (!haveStartedInterval) continue;
            haveStartedInterval = false;
            intervals.add(interval);
        }
        if (haveStartedInterval) {
            intervals.add(interval);
        }
        return (double[][])intervals.toArray((T[])new double[0][0]);
    }

    @Override
    public double predictQuantile(double percentage) {
        this.updateModel();
        double val = Statistics.normalInverse(0.975);
        double min = this.m_Min - val * this.m_Width;
        double max = this.m_Max + val * this.m_Width;
        double delta = (max - min) / (double)this.m_NumIntervals;
        double sum = 0.0;
        double leftVal = Math.exp(this.logDensity(min));
        for (int i = 0; i < this.m_NumIntervals; ++i) {
            if (sum >= percentage) {
                return min + (double)i * delta;
            }
            double rightVal = Math.exp(this.logDensity(min + (double)(i + 1) * delta));
            sum += 0.5 * (leftVal + rightVal) * delta;
            leftVal = rightVal;
        }
        return max;
    }

    @Override
    public double logDensity(double value) {
        this.updateModel();
        if (this.m_MixtureModel == null) {
            return Math.log(Double.MIN_VALUE);
        }
        try {
            return this.m_MixtureModel.logDensityForInstance(new DenseInstance(1.0, new double[]{value}));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Double.NaN;
        }
    }

    public String toString() {
        this.updateModel();
        if (this.m_MixtureModel == null) {
            return "";
        }
        return this.m_MixtureModel.toString();
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> options = new Vector<Option>();
        options.addElement(new Option("\tNumber of components to use (default: -1).", "N", 1, "-N"));
        options.addElement(new Option("\tMaximum number of components to use (default: 5).", "M", 1, "-M"));
        options.addElement(new Option("\tSeed for the random number generator (default: 1).", "S", 1, "-S"));
        options.addElement(new Option("\tThe number of bootstrap runs to use (default: 10).", "B", 1, "-B"));
        options.addElement(new Option("\tUse normalized entropy instead of bootstrap.", "E", 1, "-E"));
        return options.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String optionString = Utils.getOption("N", options);
        if (optionString.length() > 0) {
            this.setNumComponents(Integer.parseInt(optionString));
        } else {
            this.setNumComponents(-1);
        }
        optionString = Utils.getOption("M", options);
        if (optionString.length() > 0) {
            this.setMaxNumComponents(Integer.parseInt(optionString));
        } else {
            this.setMaxNumComponents(5);
        }
        optionString = Utils.getOption("S", options);
        if (optionString.length() > 0) {
            this.setSeed(Integer.parseInt(optionString));
        } else {
            this.setSeed(1);
        }
        optionString = Utils.getOption("B", options);
        if (optionString.length() > 0) {
            this.setNumBootstrapRuns(Integer.parseInt(optionString));
        } else {
            this.setNumBootstrapRuns(10);
        }
        this.m_UseNormalizedEntropy = Utils.getFlag("E", options);
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-N");
        options.add("" + this.getNumComponents());
        options.add("-M");
        options.add("" + this.getMaxNumComponents());
        options.add("-S");
        options.add("" + this.getSeed());
        options.add("-B");
        options.add("" + this.getNumBootstrapRuns());
        if (this.m_UseNormalizedEntropy) {
            options.add("-E");
        }
        return options.toArray(new String[0]);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 11365 $");
    }

    public static void main(String[] args) {
        double val;
        int i;
        int i2;
        boolean useNormalizedEntropy = true;
        Random r = new Random();
        UnivariateMixtureEstimator e = new UnivariateMixtureEstimator();
        e.setUseNormalizedEntropy(useNormalizedEntropy);
        System.out.println(e);
        double sum = 0.0;
        for (i2 = 0; i2 < 100000; ++i2) {
            sum += Math.exp(e.logDensity(r.nextDouble() * 10.0 - 5.0));
        }
        System.out.println("Approximate integral: " + 10.0 * sum / 100000.0);
        for (i2 = 0; i2 < 100000; ++i2) {
            e.addValue(r.nextGaussian() * 0.5 - 1.0, 1.0);
            e.addValue(r.nextGaussian() * 0.5 + 1.0, 3.0);
        }
        System.out.println(e);
        sum = 0.0;
        for (i2 = 0; i2 < 100000; ++i2) {
            sum += Math.exp(e.logDensity(r.nextDouble() * 10.0 - 5.0));
        }
        System.out.println("Approximate integral: " + 10.0 * sum / 100000.0);
        e = new UnivariateMixtureEstimator();
        e.setUseNormalizedEntropy(useNormalizedEntropy);
        for (i2 = 0; i2 < 100000; ++i2) {
            e.addValue(r.nextGaussian() * 0.5 - 1.0, 1.0);
            e.addValue(r.nextGaussian() * 0.5 + 1.0, 1.0);
            e.addValue(r.nextGaussian() * 0.5 + 1.0, 1.0);
            e.addValue(r.nextGaussian() * 0.5 + 1.0, 1.0);
        }
        System.out.println(e);
        sum = 0.0;
        for (i2 = 0; i2 < 100000; ++i2) {
            sum += Math.exp(e.logDensity(r.nextDouble() * 10.0 - 5.0));
        }
        System.out.println("Approximate integral: " + 10.0 * sum / 100000.0);
        e = new UnivariateMixtureEstimator();
        e.setUseNormalizedEntropy(useNormalizedEntropy);
        for (i2 = 0; i2 < 100000; ++i2) {
            e.addValue(r.nextGaussian() * 5.0 + 3.0, 1.0);
        }
        System.out.println(e);
        double[][] intervals = e.predictIntervals(0.95);
        System.out.println("Lower: " + intervals[0][0] + " Upper: " + intervals[0][1]);
        double covered = 0.0;
        for (i = 0; i < 100000; ++i) {
            val = r.nextGaussian() * 5.0 + 3.0;
            if (!(val >= intervals[0][0]) || !(val <= intervals[0][1])) continue;
            covered += 1.0;
        }
        System.out.println("Coverage: " + covered / 100000.0);
        intervals = e.predictIntervals(0.8);
        System.out.println("Lower: " + intervals[0][0] + " Upper: " + intervals[0][1]);
        covered = 0.0;
        for (i = 0; i < 100000; ++i) {
            val = r.nextGaussian() * 5.0 + 3.0;
            if (!(val >= intervals[0][0]) || !(val <= intervals[0][1])) continue;
            covered += 1.0;
        }
        System.out.println("Coverage: " + covered / 100000.0);
    }
}

