/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import weka.core.RevisionUtils;
import weka.experiment.ResultMatrix;
import weka.experiment.ResultMatrixPlainText;

public class ResultMatrixSignificance
extends ResultMatrix {
    private static final long serialVersionUID = -1280545644109764206L;

    public ResultMatrixSignificance() {
        this(1, 1);
    }

    public ResultMatrixSignificance(int cols, int rows) {
        super(cols, rows);
    }

    public ResultMatrixSignificance(ResultMatrix matrix) {
        super(matrix);
    }

    @Override
    public String globalInfo() {
        return "Only outputs the significance indicators. Can be used for spotting patterns.";
    }

    @Override
    public String getDisplayName() {
        return "Significance only";
    }

    @Override
    public boolean getDefaultPrintColNames() {
        return false;
    }

    @Override
    public int getDefaultRowNameWidth() {
        return 40;
    }

    @Override
    public boolean getDefaultShowStdDev() {
        return false;
    }

    @Override
    public void setShowStdDev(boolean show) {
    }

    @Override
    public String toStringMatrix() {
        int i;
        StringBuffer result = new StringBuffer();
        String[][] cells = this.toArray();
        int nameWidth = this.getColSize(cells, 0);
        for (i = 0; i < cells.length - 1; ++i) {
            cells[i][0] = this.padString(cells[i][0], nameWidth);
        }
        int rows = cells.length - 1;
        if (this.getShowAverage()) {
            --rows;
        }
        for (i = 0; i < rows; ++i) {
            String line = "";
            String colStr = "";
            for (int n = 0; n < cells[i].length; ++n) {
                if (this.isMean(n) || this.isRowName(n)) {
                    colStr = cells[0][n];
                }
                if (n > 1 && !this.isSignificance(n)) continue;
                if (n > 0) {
                    line = line + " ";
                }
                if (i > 0 && n > 1) {
                    line = line + " ";
                }
                if (i == 0) {
                    line = line + colStr;
                    continue;
                }
                if (n == 0) {
                    line = line + cells[i][n];
                    continue;
                }
                if (n == 1) {
                    line = line + colStr.replaceAll(".", " ");
                    continue;
                }
                line = line + cells[i][n];
                line = line + colStr.replaceAll(".", " ").substring(2);
            }
            result.append(line + "\n");
            if (i != 0) continue;
            result.append(line.replaceAll(".", "-") + "\n");
        }
        return result.toString();
    }

    @Override
    public String toStringHeader() {
        return new ResultMatrixPlainText(this).toStringHeader();
    }

    @Override
    public String toStringKey() {
        return new ResultMatrixPlainText(this).toStringKey();
    }

    @Override
    public String toStringSummary() {
        return new ResultMatrixPlainText(this).toStringSummary();
    }

    @Override
    public String toStringRanking() {
        return new ResultMatrixPlainText(this).toStringRanking();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8048 $");
    }

    public static void main(String[] args) {
        ResultMatrixSignificance matrix = new ResultMatrixSignificance(3, 3);
        matrix.addHeader("header1", "value1");
        matrix.addHeader("header2", "value2");
        matrix.addHeader("header2", "value3");
        for (int i = 0; i < matrix.getRowCount(); ++i) {
            for (int n = 0; n < matrix.getColCount(); ++n) {
                matrix.setMean(n, i, (i + 1) * n);
                matrix.setStdDev(n, i, (double)(i + 1) * (double)n / 100.0);
                if (i != n) continue;
                if (i % 2 == 1) {
                    matrix.setSignificance(n, i, 1);
                    continue;
                }
                matrix.setSignificance(n, i, 2);
            }
        }
        System.out.println("\n\n--> " + ((ResultMatrix)matrix).getDisplayName());
        System.out.println("\n1. complete\n");
        System.out.println(((ResultMatrix)matrix).toStringHeader() + "\n");
        System.out.println(((ResultMatrix)matrix).toStringMatrix() + "\n");
        System.out.println(((ResultMatrix)matrix).toStringKey());
        System.out.println("\n2. complete with std deviations\n");
        ((ResultMatrix)matrix).setShowStdDev(true);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n3. cols numbered\n");
        matrix.setPrintColNames(false);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n4. second col missing\n");
        matrix.setColHidden(1, true);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n5. last row missing, rows numbered too\n");
        matrix.setRowHidden(2, true);
        matrix.setPrintRowNames(false);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n6. mean prec to 3\n");
        matrix.setMeanPrec(3);
        matrix.setPrintRowNames(false);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
    }
}

