/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cassandra.auth.FunctionResource;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.ScalarFunction;
import org.apache.cassandra.cql3.functions.UDAggregate;
import org.apache.cassandra.cql3.functions.UDFunction;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.transport.Event;

public final class DropFunctionStatement
extends SchemaAlteringStatement {
    private FunctionName functionName;
    private final boolean ifExists;
    private final List<CQL3Type.Raw> argRawTypes;
    private final boolean argsPresent;
    private List<AbstractType<?>> argTypes;

    public DropFunctionStatement(FunctionName functionName, List<CQL3Type.Raw> argRawTypes, boolean argsPresent, boolean ifExists) {
        this.functionName = functionName;
        this.argRawTypes = argRawTypes;
        this.argsPresent = argsPresent;
        this.ifExists = ifExists;
    }

    @Override
    public ParsedStatement.Prepared prepare() throws InvalidRequestException {
        if (Schema.instance.getKSMetaData(this.functionName.keyspace) != null) {
            this.argTypes = new ArrayList(this.argRawTypes.size());
            for (CQL3Type.Raw rawType : this.argRawTypes) {
                if (rawType.isFrozen()) {
                    throw new InvalidRequestException("The function arguments should not be frozen; remove the frozen<> modifier");
                }
                if (!rawType.canBeNonFrozen()) {
                    rawType.freeze();
                }
                this.argTypes.add(rawType.prepare(this.functionName.keyspace).getType());
            }
        }
        return super.prepare();
    }

    @Override
    public void prepareKeyspace(ClientState state) throws InvalidRequestException {
        if (!this.functionName.hasKeyspace() && state.getRawKeyspace() != null) {
            this.functionName = new FunctionName(state.getKeyspace(), this.functionName.name);
        }
        if (!this.functionName.hasKeyspace()) {
            throw new InvalidRequestException("Functions must be fully qualified with a keyspace name if a keyspace is not set for the session");
        }
        ThriftValidation.validateKeyspaceNotSystem(this.functionName.keyspace);
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        Function function = this.findFunction();
        if (function == null) {
            if (!this.ifExists) {
                throw new InvalidRequestException(String.format("Unconfigured function %s.%s(%s)", this.functionName.keyspace, this.functionName.name, Joiner.on((String)",").join(this.argRawTypes)));
            }
        } else {
            state.ensureHasPermission(Permission.DROP, FunctionResource.function(function.name().keyspace, function.name().name, function.argTypes()));
        }
    }

    @Override
    public void validate(ClientState state) {
        Collection<Function> olds = Schema.instance.getFunctions(this.functionName);
        if (!this.argsPresent && olds != null && olds.size() > 1) {
            throw new InvalidRequestException(String.format("'DROP FUNCTION %s' matches multiple function definitions; specify the argument types by issuing a statement like 'DROP FUNCTION %s (type, type, ...)'. Hint: use cqlsh 'DESCRIBE FUNCTION %s' command to find all overloads", this.functionName, this.functionName, this.functionName));
        }
    }

    @Override
    public Event.SchemaChange announceMigration(QueryState queryState, boolean isLocalOnly) throws RequestValidationException {
        Function old = this.findFunction();
        if (old == null) {
            if (this.ifExists) {
                return null;
            }
            throw new InvalidRequestException(this.getMissingFunctionError());
        }
        KeyspaceMetadata ksm = Schema.instance.getKSMetaData(old.name().keyspace);
        Collection<UDAggregate> referrers = ksm.functions.aggregatesUsingFunction(old);
        if (!referrers.isEmpty()) {
            throw new InvalidRequestException(String.format("Function '%s' still referenced by %s", old, referrers));
        }
        MigrationManager.announceFunctionDrop((UDFunction)old, isLocalOnly);
        return new Event.SchemaChange(Event.SchemaChange.Change.DROPPED, Event.SchemaChange.Target.FUNCTION, old.name().keyspace, old.name().name, AbstractType.asCQLTypeStringList(old.argTypes()));
    }

    private String getMissingFunctionError() {
        StringBuilder sb = new StringBuilder("Cannot drop non existing function '");
        sb.append(this.functionName);
        if (this.argsPresent) {
            sb.append(Joiner.on((String)", ").join(this.argRawTypes));
        }
        sb.append('\'');
        return sb.toString();
    }

    private Function findFunction() {
        Function old;
        if (this.argsPresent) {
            if (this.argTypes == null) {
                return null;
            }
            old = Schema.instance.findFunction(this.functionName, this.argTypes).orElse(null);
            if (old == null || !(old instanceof ScalarFunction)) {
                return null;
            }
        } else {
            Collection<Function> olds = Schema.instance.getFunctions(this.functionName);
            if (olds == null || olds.isEmpty() || !(olds.iterator().next() instanceof ScalarFunction)) {
                return null;
            }
            old = olds.iterator().next();
        }
        return old;
    }
}

