/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.loader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public abstract class AbstractResourceData
implements ResourceData,
Serializable {
    private static final long serialVersionUID = -2578855461270413802L;

    protected AbstractResourceData() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getResource(ResourceManager caller) throws ResourceLoadingException {
        byte[] byArray;
        InputStream in = this.getResourceAsStream(caller);
        if (in == null) {
            throw new ResourceLoadingException("Unable to read Stream: No input stream: " + this.getKey());
        }
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            IOUtils.getInstance().copyStreams(in, (OutputStream)bout);
            byArray = bout.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (ResourceLoadingException rle) {
                throw rle;
            }
            catch (IOException e) {
                throw new ResourceLoadingException("Unable to read Stream: ", e);
            }
        }
        in.close();
        return byArray;
    }

    @Override
    public long getLength() {
        Object attribute = this.getAttribute("content-length");
        if (attribute instanceof Number) {
            Number length = (Number)attribute;
            return length.longValue();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getResource(ResourceManager caller, byte[] target, long offset, int length) throws ResourceLoadingException {
        int n;
        if (target == null) {
            throw new NullPointerException();
        }
        if (target.length < length) {
            throw new IndexOutOfBoundsException("Requested end-position is greater than ");
        }
        InputStream in = this.getResourceAsStream(caller);
        if (in == null) {
            throw new ResourceLoadingException("Unable to read Stream: No input stream: " + this.getKey());
        }
        try {
            if (offset > 0L) {
                long toBeSkipped = offset;
                long skipResult = in.skip(toBeSkipped);
                toBeSkipped -= skipResult;
                while (skipResult > 0L && toBeSkipped > 0L) {
                    skipResult = in.skip(offset);
                    toBeSkipped -= skipResult;
                }
                if (toBeSkipped > 0L) {
                    throw new ResourceLoadingException("Unable to read Stream: Skipping content failed: " + this.getKey());
                }
            }
            int bytesToRead = length;
            int bytesRead = in.read(target, length - bytesToRead, bytesToRead);
            while (bytesRead > -1 && bytesToRead > 0) {
                bytesRead = in.read(target, length - (bytesToRead -= bytesRead), bytesToRead);
            }
            n = length - bytesRead;
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (ResourceLoadingException rle) {
                throw rle;
            }
            catch (IOException e) {
                throw new ResourceLoadingException("Unable to read Stream: ", e);
            }
        }
        in.close();
        return n;
    }
}

