/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Hashtable;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BaseTableNumbersVisitor;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.InListOperatorNode;
import org.apache.derby.impl.sql.compile.OrNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.RelationalOperator;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;

public final class Predicate
extends QueryTreeNode
implements OptimizablePredicate,
Comparable {
    AndNode andNode;
    boolean pushable;
    JBitSet referencedSet;
    int equivalenceClass = -1;
    int indexPosition;
    protected boolean startKey;
    protected boolean stopKey;
    protected boolean isQualifier;
    private Hashtable searchClauseHT;
    private boolean scoped;

    public void init(Object object, Object object2) {
        this.andNode = (AndNode)object;
        this.pushable = false;
        this.referencedSet = (JBitSet)object2;
        this.scoped = false;
    }

    public JBitSet getReferencedMap() {
        return this.referencedSet;
    }

    public boolean hasSubquery() {
        return !this.pushable;
    }

    public boolean hasMethodCall() {
        return !this.pushable;
    }

    public void markStartKey() {
        this.startKey = true;
    }

    public boolean isStartKey() {
        return this.startKey;
    }

    public void markStopKey() {
        this.stopKey = true;
    }

    public boolean isStopKey() {
        return this.stopKey;
    }

    public void markQualifier() {
        this.isQualifier = true;
    }

    public boolean isQualifier() {
        return this.isQualifier;
    }

    public boolean compareWithKnownConstant(Optimizable optimizable, boolean bl) {
        boolean bl2 = false;
        RelationalOperator relationalOperator = this.getRelop();
        if (relationalOperator == null) {
            return false;
        }
        if (relationalOperator.compareWithKnownConstant(optimizable, bl)) {
            bl2 = true;
        }
        return bl2;
    }

    public int hasEqualOnColumnList(int[] nArray, Optimizable optimizable) throws StandardException {
        RelationalOperator relationalOperator = this.getRelop();
        if (relationalOperator == null) {
            return -1;
        }
        if (relationalOperator.getOperator() != 1) {
            return -1;
        }
        for (int i = 0; i < nArray.length; ++i) {
            ColumnReference columnReference = relationalOperator.getColumnOperand(optimizable, nArray[i]);
            if (columnReference == null || relationalOperator.selfComparison(columnReference)) continue;
            return i;
        }
        return -1;
    }

    public DataValueDescriptor getCompareValue(Optimizable optimizable) throws StandardException {
        RelationalOperator relationalOperator = this.getRelop();
        return relationalOperator.getCompareValue(optimizable);
    }

    public boolean equalsComparisonWithConstantExpression(Optimizable optimizable) {
        RelationalOperator relationalOperator = this.getRelop();
        boolean bl = false;
        if (relationalOperator != null) {
            bl = relationalOperator.equalsComparisonWithConstantExpression(optimizable);
        }
        return bl;
    }

    public double selectivity(Optimizable optimizable) throws StandardException {
        return this.andNode.getLeftOperand().selectivity(optimizable);
    }

    public int getIndexPosition() {
        return this.indexPosition;
    }

    public int compareTo(Object object) {
        boolean bl;
        int n;
        Predicate predicate = (Predicate)object;
        int n2 = predicate.getIndexPosition();
        if (this.indexPosition < n2) {
            return -1;
        }
        if (this.indexPosition > n2) {
            return 1;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        boolean bl5 = true;
        if (this.getRelop() != null) {
            n = ((RelationalOperator)((Object)this.andNode.getLeftOperand())).getOperator();
            bl2 = n == 1 || n == 7;
            boolean bl6 = bl4 = n == 2 || n == 8;
        }
        if (predicate.getRelop() != null) {
            n = ((RelationalOperator)((Object)predicate.getAndNode().getLeftOperand())).getOperator();
            bl3 = n == 1 || n == 7;
            bl5 = n == 2 || n == 8;
        }
        int n3 = n = bl2 && !bl3 || !bl4 && bl5 ? 1 : 0;
        if (n != 0) {
            return -1;
        }
        boolean bl7 = bl = bl3 && !bl2 || !bl5 && bl4;
        if (bl) {
            return 1;
        }
        return 0;
    }

    public AndNode getAndNode() {
        return this.andNode;
    }

    public void setAndNode(AndNode andNode) {
        this.andNode = andNode;
    }

    public boolean getPushable() {
        return this.pushable;
    }

    public void setPushable(boolean bl) {
        this.pushable = bl;
    }

    public JBitSet getReferencedSet() {
        return this.referencedSet;
    }

    void setEquivalenceClass(int n) {
        this.equivalenceClass = n;
    }

    int getEquivalenceClass() {
        return this.equivalenceClass;
    }

    public void categorize() throws StandardException {
        this.pushable = this.andNode.categorize(this.referencedSet, false);
    }

    public RelationalOperator getRelop() {
        if (this.andNode.getLeftOperand() instanceof RelationalOperator) {
            return (RelationalOperator)((Object)this.andNode.getLeftOperand());
        }
        return null;
    }

    public final boolean isOrList() {
        return this.andNode.getLeftOperand() instanceof OrNode;
    }

    public final boolean isStoreQualifier() {
        return this.andNode.getLeftOperand() instanceof RelationalOperator || this.andNode.getLeftOperand() instanceof OrNode;
    }

    public final boolean isPushableOrClause(Optimizable optimizable) throws StandardException {
        boolean bl = true;
        if (this.andNode.getLeftOperand() instanceof OrNode) {
            ValueNode valueNode = this.andNode.getLeftOperand();
            while (valueNode instanceof OrNode) {
                OrNode orNode = (OrNode)valueNode;
                if (orNode.getLeftOperand() instanceof RelationalOperator) {
                    if (!((RelationalOperator)((Object)orNode.getLeftOperand())).isQualifier(optimizable, true)) {
                        return false;
                    }
                    valueNode = orNode.getRightOperand();
                    continue;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    boolean transitiveSearchClauseAdded(RelationalOperator relationalOperator) {
        return this.searchClauseHT != null && this.searchClauseHT.get(new Integer(relationalOperator.getOperator())) != null;
    }

    void setTransitiveSearchClauseAdded(RelationalOperator relationalOperator) {
        if (this.searchClauseHT == null) {
            this.searchClauseHT = new Hashtable();
        }
        Integer n = new Integer(relationalOperator.getOperator());
        this.searchClauseHT.put(n, n);
    }

    int getStartOperator(Optimizable optimizable) {
        if (this.andNode.getLeftOperand() instanceof InListOperatorNode) {
            return 1;
        }
        return this.getRelop().getStartOperator(optimizable);
    }

    int getStopOperator(Optimizable optimizable) {
        if (this.andNode.getLeftOperand() instanceof InListOperatorNode) {
            return -1;
        }
        return this.getRelop().getStopOperator(optimizable);
    }

    void setIndexPosition(int n) {
        this.indexPosition = n;
    }

    void clearScanFlags() {
        this.startKey = false;
        this.stopKey = false;
        this.isQualifier = false;
    }

    void clearQualifierFlag() {
        this.isQualifier = false;
    }

    void generateExpressionOperand(Optimizable optimizable, int n, ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.getRelop().generateExpressionOperand(optimizable, n, expressionClassBuilder, methodBuilder);
    }

    void generateAbsoluteColumnId(MethodBuilder methodBuilder, Optimizable optimizable) {
        this.getRelop().generateAbsoluteColumnId(methodBuilder, optimizable);
    }

    void generateRelativeColumnId(MethodBuilder methodBuilder, Optimizable optimizable) {
        this.getRelop().generateRelativeColumnId(methodBuilder, optimizable);
    }

    void generateOperator(MethodBuilder methodBuilder, Optimizable optimizable) {
        this.getRelop().generateOperator(methodBuilder, optimizable);
    }

    void generateQualMethod(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, Optimizable optimizable) throws StandardException {
        this.getRelop().generateQualMethod(expressionClassBuilder, methodBuilder, optimizable);
    }

    void generateOrderedNulls(MethodBuilder methodBuilder) {
        this.getRelop().generateOrderedNulls(methodBuilder);
    }

    void generateNegate(MethodBuilder methodBuilder, Optimizable optimizable) {
        this.getRelop().generateNegate(methodBuilder, optimizable);
    }

    void generateOrderableVariantType(MethodBuilder methodBuilder, Optimizable optimizable) throws StandardException {
        int n = this.getRelop().getOrderableVariantType(optimizable);
        methodBuilder.push(n);
    }

    public String toString() {
        return "";
    }

    public String binaryRelOpColRefsToString() {
        if (!(this.getAndNode().getLeftOperand() instanceof BinaryRelationalOperatorNode)) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        BinaryRelationalOperatorNode binaryRelationalOperatorNode = (BinaryRelationalOperatorNode)this.getAndNode().getLeftOperand();
        if (binaryRelationalOperatorNode.getLeftOperand() instanceof ColumnReference) {
            stringBuffer.append(((ColumnReference)binaryRelationalOperatorNode.getLeftOperand()).getTableName() + "." + ((ColumnReference)binaryRelationalOperatorNode.getLeftOperand()).getColumnName());
        } else {
            stringBuffer.append("<expr>");
        }
        stringBuffer.append(" " + binaryRelationalOperatorNode.operator + " ");
        if (binaryRelationalOperatorNode.getRightOperand() instanceof ColumnReference) {
            stringBuffer.append(((ColumnReference)binaryRelationalOperatorNode.getRightOperand()).getTableName() + "." + ((ColumnReference)binaryRelationalOperatorNode.getRightOperand()).getColumnName());
        } else {
            stringBuffer.append("<expr>");
        }
        return stringBuffer.toString();
    }

    public void printSubNodes(int n) {
    }

    public Visitable accept(Visitor visitor) throws StandardException {
        if (visitor.skipChildren(this)) {
            return visitor.visit(this);
        }
        Visitable visitable = super.accept(visitor);
        if (this.andNode != null && !visitor.stopTraversal()) {
            this.andNode = (AndNode)this.andNode.accept(visitor);
        }
        return visitable;
    }

    public void copyFields(Predicate predicate) {
        this.equivalenceClass = predicate.getEquivalenceClass();
        this.indexPosition = predicate.getIndexPosition();
        this.startKey = predicate.isStartKey();
        this.stopKey = predicate.isStopKey();
        this.isQualifier = predicate.isQualifier();
        this.searchClauseHT = predicate.getSearchClauseHT();
    }

    public Hashtable getSearchClauseHT() {
        return this.searchClauseHT;
    }

    protected boolean pushableToSubqueries() throws StandardException {
        if (!this.isJoinPredicate()) {
            return false;
        }
        BinaryRelationalOperatorNode binaryRelationalOperatorNode = (BinaryRelationalOperatorNode)this.getAndNode().getLeftOperand();
        JBitSet jBitSet = new JBitSet(this.getReferencedSet().size());
        BaseTableNumbersVisitor baseTableNumbersVisitor = new BaseTableNumbersVisitor(jBitSet);
        binaryRelationalOperatorNode.getLeftOperand().accept(baseTableNumbersVisitor);
        if (jBitSet.getFirstSetBit() == -1) {
            return false;
        }
        jBitSet.clearAll();
        binaryRelationalOperatorNode.getRightOperand().accept(baseTableNumbersVisitor);
        return jBitSet.getFirstSetBit() != -1;
    }

    protected boolean isJoinPredicate() {
        if (!(this.getAndNode().getLeftOperand() instanceof BinaryRelationalOperatorNode)) {
            return false;
        }
        BinaryRelationalOperatorNode binaryRelationalOperatorNode = (BinaryRelationalOperatorNode)this.getAndNode().getLeftOperand();
        return binaryRelationalOperatorNode.getLeftOperand() instanceof ColumnReference && binaryRelationalOperatorNode.getRightOperand() instanceof ColumnReference && ((ColumnReference)binaryRelationalOperatorNode.getLeftOperand()).getTableNumber() != ((ColumnReference)binaryRelationalOperatorNode.getRightOperand()).getTableNumber();
    }

    protected Predicate getPredScopedForResultSet(JBitSet jBitSet, ResultSetNode resultSetNode, int[] nArray) throws StandardException {
        if (!(this.getAndNode().getLeftOperand() instanceof BinaryRelationalOperatorNode)) {
            return this;
        }
        ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(38, Boolean.TRUE, this.getContextManager());
        BinaryRelationalOperatorNode binaryRelationalOperatorNode = (BinaryRelationalOperatorNode)this.getAndNode().getLeftOperand();
        BinaryRelationalOperatorNode binaryRelationalOperatorNode2 = (BinaryRelationalOperatorNode)this.getNodeFactory().getNode(binaryRelationalOperatorNode.getNodeType(), binaryRelationalOperatorNode.getScopedOperand(-1, jBitSet, resultSetNode, nArray), binaryRelationalOperatorNode.getScopedOperand(1, jBitSet, resultSetNode, nArray), this.getContextManager());
        binaryRelationalOperatorNode2.bindComparisonOperator();
        AndNode andNode = (AndNode)this.getNodeFactory().getNode(39, binaryRelationalOperatorNode2, valueNode, this.getContextManager());
        andNode.postBindFixup();
        JBitSet jBitSet2 = new JBitSet(resultSetNode.getReferencedTableMap().size());
        andNode.categorize(jBitSet2, false);
        Predicate predicate = (Predicate)this.getNodeFactory().getNode(78, andNode, jBitSet2, this.getContextManager());
        predicate.clearScanFlags();
        predicate.copyFields(this);
        predicate.setPushable(this.getPushable());
        predicate.markAsScopedForPush();
        return predicate;
    }

    protected void markAsScopedForPush() {
        this.scoped = true;
    }

    protected boolean isScopedForPush() {
        return this.scoped;
    }

    protected boolean remapScopedPred() {
        if (!this.scoped) {
            return false;
        }
        BinaryRelationalOperatorNode binaryRelationalOperatorNode = (BinaryRelationalOperatorNode)this.andNode.getLeftOperand();
        ValueNode valueNode = null;
        valueNode = binaryRelationalOperatorNode.getLeftOperand();
        if (valueNode instanceof ColumnReference && ((ColumnReference)valueNode).isScoped()) {
            ((ColumnReference)valueNode).remapColumnReferences();
        } else {
            valueNode = binaryRelationalOperatorNode.getRightOperand();
            if (valueNode instanceof ColumnReference && ((ColumnReference)valueNode).isScoped()) {
                ((ColumnReference)valueNode).remapColumnReferences();
            }
        }
        return true;
    }

    protected boolean isScopedToSourceResultSet() throws StandardException {
        if (!this.scoped) {
            return false;
        }
        BinaryRelationalOperatorNode binaryRelationalOperatorNode = (BinaryRelationalOperatorNode)this.andNode.getLeftOperand();
        ValueNode valueNode = binaryRelationalOperatorNode.getLeftOperand();
        if (!(valueNode instanceof ColumnReference)) {
            return false;
        }
        ValueNode valueNode2 = null;
        ColumnReference columnReference = (ColumnReference)valueNode;
        if (columnReference.isScoped()) {
            valueNode2 = columnReference.getSource().getExpression();
            return valueNode2 instanceof VirtualColumnNode || valueNode2 instanceof ColumnReference;
        }
        valueNode = binaryRelationalOperatorNode.getRightOperand();
        if (!(valueNode instanceof ColumnReference)) {
            return false;
        }
        columnReference = (ColumnReference)valueNode;
        valueNode2 = columnReference.getSource().getExpression();
        return valueNode2 instanceof VirtualColumnNode || valueNode2 instanceof ColumnReference;
    }
}

