/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromSubquery;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.HasVariantValueNodeVisitor;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;

public class RowResultSetNode
extends FromTable {
    SubqueryList subquerys;
    Vector aggregateVector;
    OrderByList orderByList;

    public void init(Object object, Object object2) {
        super.init(null, object2);
        this.resultColumns = (ResultColumnList)object;
        if (this.resultColumns != null) {
            this.resultColumns.markInitialSize();
        }
    }

    public String toString() {
        return "";
    }

    public String statementToString() {
        return "VALUES";
    }

    public void printSubNodes(int n) {
    }

    public CostEstimate estimateCost(OptimizablePredicateList optimizablePredicateList, ConglomerateDescriptor conglomerateDescriptor, CostEstimate costEstimate, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        if (this.costEstimate == null) {
            this.costEstimate = optimizer.newCostEstimate();
        }
        this.costEstimate.setCost(0.0, 1.0, 1.0);
        rowOrdering.optimizableAlwaysOrdered(this);
        return this.costEstimate;
    }

    public ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromList) throws StandardException {
        if (this.tableNumber == -1) {
            this.tableNumber = this.getCompilerContext().getNextTableNumber();
        }
        return this;
    }

    public void bindExpressions(FromList fromList) throws StandardException {
        this.subquerys = (SubqueryList)this.getNodeFactory().getNode(11, this.getContextManager());
        this.aggregateVector = new Vector();
        this.resultColumns.checkForInvalidDefaults();
        int n = fromList.size() == 0 ? 0 : ((FromTable)fromList.elementAt(0)).getLevel() + 1;
        this.setLevel(n);
        fromList.insertElementAt(this, 0);
        this.resultColumns.bindExpressions(fromList, this.subquerys, this.aggregateVector);
        fromList.removeElementAt(0);
        if (this.aggregateVector.size() > 0) {
            throw StandardException.newException("42903");
        }
    }

    public void bindExpressionsWithTables(FromList fromList) throws StandardException {
    }

    public void bindTargetExpressions(FromList fromList) throws StandardException {
        this.bindExpressions(fromList);
    }

    public void bindUntypedNullsToResultColumns(ResultColumnList resultColumnList) throws StandardException {
        if (resultColumnList == null) {
            resultColumnList = this.resultColumns;
        }
        this.resultColumns.bindUntypedNullsToResultColumns(resultColumnList);
    }

    public ResultColumn getMatchingColumn(ColumnReference columnReference) throws StandardException {
        return null;
    }

    public String getExposedName() throws StandardException {
        return null;
    }

    public void verifySelectStarSubquery(FromList fromList, int n) throws StandardException {
    }

    void pushOrderByList(OrderByList orderByList) {
        this.orderByList = orderByList;
    }

    public ResultSetNode preprocess(int n, GroupByList groupByList, FromList fromList) throws StandardException {
        if (this.subquerys.size() > 0) {
            this.subquerys.preprocess(n, (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()), (SubqueryList)this.getNodeFactory().getNode(11, this.getContextManager()), (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager()));
        }
        this.referencedTableMap = new JBitSet(n);
        this.referencedTableMap.set(this.tableNumber);
        return this;
    }

    public ResultSetNode ensurePredicateList(int n) throws StandardException {
        return this.genProjectRestrict(n);
    }

    public ResultSetNode addNewPredicate(Predicate predicate) throws StandardException {
        ResultColumnList resultColumnList = this.resultColumns;
        this.resultColumns = this.resultColumns.copyListAndObjects();
        resultColumnList.genVirtualColumnNodes(this, this.resultColumns);
        PredicateList predicateList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        predicateList.addPredicate(predicate);
        return (ResultSetNode)this.getNodeFactory().getNode(151, this, resultColumnList, null, predicateList, null, null, this.tableProperties, this.getContextManager());
    }

    public boolean flattenableInFromSubquery(FromList fromList) {
        if (this.subquerys != null && this.subquerys.size() > 0) {
            return false;
        }
        if (this.aggregateVector != null && this.aggregateVector.size() > 0) {
            return false;
        }
        if (!this.resultColumns.isCloneable()) {
            return false;
        }
        boolean bl = false;
        int n = fromList.size();
        for (int i = 0; i < n; ++i) {
            FromTable fromTable = (FromTable)fromList.elementAt(i);
            if (fromTable instanceof FromSubquery) {
                ResultSetNode resultSetNode = ((FromSubquery)fromTable).getSubquery();
                if (resultSetNode instanceof RowResultSetNode) continue;
                bl = true;
                break;
            }
            bl = true;
            break;
        }
        return bl;
    }

    public ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicateList, double d) throws StandardException {
        Optimizer optimizer = this.getOptimizer((FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()), predicateList, dataDictionary, null);
        this.costEstimate = optimizer.newCostEstimate();
        this.costEstimate.setCost(0.0, d, d);
        this.subquerys.optimize(dataDictionary, d);
        return this;
    }

    public Optimizable modifyAccessPath(JBitSet jBitSet) throws StandardException {
        return (Optimizable)((Object)this.modifyAccessPaths());
    }

    public ResultSetNode modifyAccessPaths() throws StandardException {
        ResultSetNode resultSetNode = this;
        this.subquerys.modifyAccessPaths();
        if (this.orderByList != null) {
            resultSetNode = (ResultSetNode)this.getNodeFactory().getNode(140, resultSetNode, this.orderByList, this.tableProperties, this.getContextManager());
        }
        return resultSetNode;
    }

    boolean returnsAtMostOneRow() {
        return true;
    }

    public void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.costEstimate = this.getFinalCostEstimate();
        boolean bl = this.canWeCacheResults();
        this.assignResultSetNumber();
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        activationClassBuilder.pushThisAsActivation(methodBuilder);
        this.resultColumns.generate(activationClassBuilder, methodBuilder);
        methodBuilder.push(bl);
        methodBuilder.push(this.resultSetNumber);
        methodBuilder.push(this.costEstimate.rowCount());
        methodBuilder.push(this.costEstimate.getEstimatedCost());
        methodBuilder.callMethod((short)185, null, "getRowResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 6);
    }

    void replaceDefaults(TableDescriptor tableDescriptor, ResultColumnList resultColumnList) throws StandardException {
        this.resultColumns.replaceDefaults(tableDescriptor, resultColumnList);
    }

    void optimizeSubqueries(DataDictionary dataDictionary, double d) throws StandardException {
        this.subquerys.optimize(dataDictionary, d);
    }

    void markOrderingDependent() {
    }

    private boolean canWeCacheResults() throws StandardException {
        HasVariantValueNodeVisitor hasVariantValueNodeVisitor = new HasVariantValueNodeVisitor(2, true);
        super.accept(hasVariantValueNodeVisitor);
        boolean bl = !hasVariantValueNodeVisitor.hasVariant();
        return bl;
    }
}

