/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig;

import java.io.Serializable;
import org.apache.pig.PigException;

public enum ExecType implements Serializable
{
    LOCAL,
    MAPREDUCE;


    public static ExecType fromString(String execString) throws PigException {
        if (execString.equals("mapred")) {
            return MAPREDUCE;
        }
        try {
            return ExecType.valueOf(execString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            int errCode = 2040;
            String msg = "Unknown exec type: " + execString;
            throw new PigException(msg, errCode, e);
        }
    }
}

