/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util.avro;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.avro.AvroStorageSchemaConversionUtilities;
import org.joda.time.DateTime;

public class AvroStorageDataConversionUtilities {
    public static GenericData.Record packIntoAvro(Tuple t, Schema s) throws IOException {
        try {
            GenericData.Record record = new GenericData.Record(s);
            block8: for (Schema.Field f : s.getFields()) {
                Object o = t.get(f.pos());
                Schema innerSchema = f.schema();
                if (AvroStorageSchemaConversionUtilities.isNullableUnion(innerSchema)) {
                    if (o == null) {
                        record.put(f.pos(), null);
                        continue;
                    }
                    innerSchema = AvroStorageSchemaConversionUtilities.removeSimpleUnion(innerSchema);
                }
                switch (innerSchema.getType()) {
                    case RECORD: {
                        record.put(f.pos(), (Object)AvroStorageDataConversionUtilities.packIntoAvro((Tuple)o, innerSchema));
                        continue block8;
                    }
                    case ARRAY: {
                        record.put(f.pos(), AvroStorageDataConversionUtilities.packIntoAvro((DataBag)o, innerSchema));
                        continue block8;
                    }
                    case BYTES: {
                        record.put(f.pos(), (Object)ByteBuffer.wrap(((DataByteArray)o).get()));
                        continue block8;
                    }
                    case FIXED: {
                        record.put(f.pos(), (Object)new GenericData.Fixed(innerSchema, ((DataByteArray)o).get()));
                        continue block8;
                    }
                }
                if (t.getType(f.pos()) == 30) {
                    record.put(f.pos(), (Object)((DateTime)o).getMillis());
                    continue;
                }
                record.put(f.pos(), o);
            }
            return record;
        }
        catch (Exception e) {
            throw new IOException("exception in AvroStorageDataConversionUtilities.packIntoAvro", e);
        }
    }

    public static GenericData.Array<Object> packIntoAvro(DataBag db, Schema s) throws IOException {
        try {
            GenericData.Array array = new GenericData.Array(new Long(db.size()).intValue(), s);
            for (Tuple t : db) {
                if (s.getElementType() != null && s.getElementType().getType() == Schema.Type.RECORD) {
                    array.add((Object)AvroStorageDataConversionUtilities.packIntoAvro(t, s.getElementType()));
                    continue;
                }
                if (t.size() == 1) {
                    array.add(t.get(0));
                    continue;
                }
                throw new IOException("AvroStorageDataConversionUtilities.packIntoAvro: Can't pack " + t + " into schema " + s);
            }
            return array;
        }
        catch (Exception e) {
            throw new IOException("exception in AvroStorageDataConversionUtilities.packIntoAvro", e);
        }
    }
}

