/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.List;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.TrackingUriPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyUriUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyUriUtils.class);
    public static final String PROXY_SERVLET_NAME = "proxy";
    public static final String PROXY_BASE = "/proxy/";
    public static final String REDIRECT = "redirect/";
    public static final String PROXY_PATH_SPEC = "/proxy/*";
    public static final String PROXY_APPROVAL_PARAM = "proxyapproved";

    private static String uriEncode(Object o) {
        try {
            assert (o != null) : "o canot be null";
            return URLEncoder.encode(o.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 is not supported by this system?", e);
        }
    }

    public static String getPath(ApplicationId id) {
        return ProxyUriUtils.getPath(id, false);
    }

    public static String getPath(ApplicationId id, boolean redirected) {
        if (id == null) {
            throw new IllegalArgumentException("Application id cannot be null ");
        }
        if (redirected) {
            return StringHelper.ujoin((String)PROXY_BASE, (String[])new String[]{REDIRECT, ProxyUriUtils.uriEncode(id)});
        }
        return StringHelper.ujoin((String)PROXY_BASE, (String[])new String[]{ProxyUriUtils.uriEncode(id)});
    }

    public static String getPath(ApplicationId id, String path) {
        return ProxyUriUtils.getPath(id, path, false);
    }

    public static String getPath(ApplicationId id, String path, boolean redirected) {
        if (path == null) {
            return ProxyUriUtils.getPath(id, redirected);
        }
        return StringHelper.ujoin((String)ProxyUriUtils.getPath(id, redirected), (String[])new String[]{path});
    }

    public static String getPathAndQuery(ApplicationId id, String path, String query, boolean approved) {
        StringBuilder newp = new StringBuilder();
        newp.append(ProxyUriUtils.getPath(id, path));
        boolean first = ProxyUriUtils.appendQuery(newp, query, true);
        if (approved) {
            ProxyUriUtils.appendQuery(newp, "proxyapproved=true", first);
        }
        return newp.toString();
    }

    private static boolean appendQuery(StringBuilder builder, String query, boolean first) {
        if (query != null && !query.isEmpty()) {
            if (first && !query.startsWith("?")) {
                builder.append('?');
            }
            if (!first && !query.startsWith("&")) {
                builder.append('&');
            }
            builder.append(query);
            return false;
        }
        return first;
    }

    public static URI getProxyUri(URI originalUri, URI proxyUri, ApplicationId id) {
        try {
            String path = ProxyUriUtils.getPath(id, originalUri == null ? "/" : originalUri.getPath());
            return new URI(proxyUri.getScheme(), proxyUri.getAuthority(), path, originalUri == null ? null : originalUri.getQuery(), originalUri == null ? null : originalUri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Could not proxify " + originalUri, e);
        }
    }

    public static URI getUriFromAMUrl(String scheme, String noSchemeUrl) throws URISyntaxException {
        if (ProxyUriUtils.getSchemeFromUrl(noSchemeUrl).isEmpty()) {
            return new URI(scheme + noSchemeUrl);
        }
        return new URI(noSchemeUrl);
    }

    public static URI getUriFromTrackingPlugins(ApplicationId id, List<TrackingUriPlugin> trackingUriPlugins) throws URISyntaxException {
        URI toRet = null;
        for (TrackingUriPlugin plugin : trackingUriPlugins) {
            toRet = plugin.getTrackingUri(id);
            if (toRet == null) continue;
            return toRet;
        }
        return null;
    }

    public static String getSchemeFromUrl(String url) {
        int index = 0;
        if (url != null) {
            index = url.indexOf("://");
        }
        if (index > 0) {
            return url.substring(0, index);
        }
        return "";
    }
}

