/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.wf.WorkflowXCommand;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;

public class WfEndXCommand
extends WorkflowXCommand<Void> {
    private WorkflowJob job = null;

    public WfEndXCommand(WorkflowJob job) {
        super("wf_end", "wf_end", 1);
        this.job = job;
    }

    @Override
    protected Void execute() throws CommandException {
        this.LOG.debug("STARTED WFEndXCommand " + this.job.getId());
        this.deleteWFDir();
        this.LOG.debug("ENDED WFEndXCommand " + this.job.getId());
        return null;
    }

    private void deleteWFDir() throws CommandException {
        try {
            FileSystem fs = this.getAppFileSystem(this.job);
            String wfDir = Services.get().getSystemId() + "/" + this.job.getId();
            Path wfDirPath = new Path(fs.getHomeDirectory(), wfDir);
            this.LOG.debug("WF tmp dir :" + wfDirPath);
            if (fs.exists(wfDirPath)) {
                fs.delete(wfDirPath, true);
            } else {
                this.LOG.debug("Tmp dir doesn't exist :" + wfDirPath);
            }
        }
        catch (Exception e) {
            this.LOG.error((Object)("Unable to delete WF temp dir of wf id :" + this.job.getId()), e);
            throw new CommandException(ErrorCode.E0819, this.job.getId(), e);
        }
    }

    protected FileSystem getAppFileSystem(WorkflowJob workflow) throws HadoopAccessorException, IOException, URISyntaxException {
        URI uri = new URI(workflow.getAppPath());
        HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
        JobConf fsConf = has.createJobConf(uri.getAuthority());
        return has.createFileSystem(workflow.getUser(), uri, (Configuration)fsConf);
    }

    @Override
    public String getEntityKey() {
        return this.job.getId();
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }

    @Override
    protected void loadState() throws CommandException {
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }
}

