/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckRequest;
import com.amazonaws.services.elasticloadbalancing.model.HealthCheck;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigureHealthCheckRequestMarshaller
implements Marshaller<Request<ConfigureHealthCheckRequest>, ConfigureHealthCheckRequest> {
    @Override
    public Request<ConfigureHealthCheckRequest> marshall(ConfigureHealthCheckRequest configureHealthCheckRequest) {
        HealthCheck healthCheckHealthCheck;
        if (configureHealthCheckRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ConfigureHealthCheckRequest> request = new DefaultRequest<ConfigureHealthCheckRequest>(configureHealthCheckRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "ConfigureHealthCheck");
        request.addParameter("Version", "2012-06-01");
        if (configureHealthCheckRequest.getLoadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringUtils.fromString(configureHealthCheckRequest.getLoadBalancerName()));
        }
        if ((healthCheckHealthCheck = configureHealthCheckRequest.getHealthCheck()) != null) {
            if (healthCheckHealthCheck.getTarget() != null) {
                request.addParameter("HealthCheck.Target", StringUtils.fromString(healthCheckHealthCheck.getTarget()));
            }
            if (healthCheckHealthCheck.getInterval() != null) {
                request.addParameter("HealthCheck.Interval", StringUtils.fromInteger(healthCheckHealthCheck.getInterval()));
            }
            if (healthCheckHealthCheck.getTimeout() != null) {
                request.addParameter("HealthCheck.Timeout", StringUtils.fromInteger(healthCheckHealthCheck.getTimeout()));
            }
            if (healthCheckHealthCheck.getUnhealthyThreshold() != null) {
                request.addParameter("HealthCheck.UnhealthyThreshold", StringUtils.fromInteger(healthCheckHealthCheck.getUnhealthyThreshold()));
            }
            if (healthCheckHealthCheck.getHealthyThreshold() != null) {
                request.addParameter("HealthCheck.HealthyThreshold", StringUtils.fromInteger(healthCheckHealthCheck.getHealthyThreshold()));
            }
        }
        return request;
    }
}

