/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.simpleemail.model.Destination;
import com.amazonaws.services.simpleemail.model.Message;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendEmailRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String source;
    private Destination destination;
    private Message message;
    private ListWithAutoConstructFlag<String> replyToAddresses;
    private String returnPath;

    public SendEmailRequest() {
    }

    public SendEmailRequest(String source, Destination destination, Message message) {
        this.setSource(source);
        this.setDestination(destination);
        this.setMessage(message);
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public SendEmailRequest withSource(String source) {
        this.source = source;
        return this;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public SendEmailRequest withDestination(Destination destination) {
        this.destination = destination;
        return this;
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public SendEmailRequest withMessage(Message message) {
        this.message = message;
        return this;
    }

    public List<String> getReplyToAddresses() {
        if (this.replyToAddresses == null) {
            this.replyToAddresses = new ListWithAutoConstructFlag();
            this.replyToAddresses.setAutoConstruct(true);
        }
        return this.replyToAddresses;
    }

    public void setReplyToAddresses(Collection<String> replyToAddresses) {
        if (replyToAddresses == null) {
            this.replyToAddresses = null;
            return;
        }
        ListWithAutoConstructFlag replyToAddressesCopy = new ListWithAutoConstructFlag(replyToAddresses.size());
        replyToAddressesCopy.addAll(replyToAddresses);
        this.replyToAddresses = replyToAddressesCopy;
    }

    public SendEmailRequest withReplyToAddresses(String ... replyToAddresses) {
        if (this.getReplyToAddresses() == null) {
            this.setReplyToAddresses(new ArrayList<String>(replyToAddresses.length));
        }
        for (String value : replyToAddresses) {
            this.getReplyToAddresses().add(value);
        }
        return this;
    }

    public SendEmailRequest withReplyToAddresses(Collection<String> replyToAddresses) {
        if (replyToAddresses == null) {
            this.replyToAddresses = null;
        } else {
            ListWithAutoConstructFlag replyToAddressesCopy = new ListWithAutoConstructFlag(replyToAddresses.size());
            replyToAddressesCopy.addAll(replyToAddresses);
            this.replyToAddresses = replyToAddressesCopy;
        }
        return this;
    }

    public String getReturnPath() {
        return this.returnPath;
    }

    public void setReturnPath(String returnPath) {
        this.returnPath = returnPath;
    }

    public SendEmailRequest withReturnPath(String returnPath) {
        this.returnPath = returnPath;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSource() != null) {
            sb.append("Source: " + this.getSource() + ",");
        }
        if (this.getDestination() != null) {
            sb.append("Destination: " + this.getDestination() + ",");
        }
        if (this.getMessage() != null) {
            sb.append("Message: " + this.getMessage() + ",");
        }
        if (this.getReplyToAddresses() != null) {
            sb.append("ReplyToAddresses: " + this.getReplyToAddresses() + ",");
        }
        if (this.getReturnPath() != null) {
            sb.append("ReturnPath: " + this.getReturnPath());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        hashCode = 31 * hashCode + (this.getDestination() == null ? 0 : this.getDestination().hashCode());
        hashCode = 31 * hashCode + (this.getMessage() == null ? 0 : this.getMessage().hashCode());
        hashCode = 31 * hashCode + (this.getReplyToAddresses() == null ? 0 : this.getReplyToAddresses().hashCode());
        hashCode = 31 * hashCode + (this.getReturnPath() == null ? 0 : this.getReturnPath().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendEmailRequest)) {
            return false;
        }
        SendEmailRequest other = (SendEmailRequest)obj;
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        if (other.getSource() != null && !other.getSource().equals(this.getSource())) {
            return false;
        }
        if (other.getDestination() == null ^ this.getDestination() == null) {
            return false;
        }
        if (other.getDestination() != null && !other.getDestination().equals(this.getDestination())) {
            return false;
        }
        if (other.getMessage() == null ^ this.getMessage() == null) {
            return false;
        }
        if (other.getMessage() != null && !other.getMessage().equals(this.getMessage())) {
            return false;
        }
        if (other.getReplyToAddresses() == null ^ this.getReplyToAddresses() == null) {
            return false;
        }
        if (other.getReplyToAddresses() != null && !other.getReplyToAddresses().equals(this.getReplyToAddresses())) {
            return false;
        }
        if (other.getReturnPath() == null ^ this.getReturnPath() == null) {
            return false;
        }
        return other.getReturnPath() == null || other.getReturnPath().equals(this.getReturnPath());
    }
}

